/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.AbstractOnSubscribe;

public final class Serialized {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static <T extends Serializable> Observable<T> read(final ObjectInputStream ois) {
        return Observable.create((Observable.OnSubscribe)new AbstractOnSubscribe<T, ObjectInputStream>(){

            protected ObjectInputStream onSubscribe(Subscriber<? super T> subscriber) {
                return ois;
            }

            protected void next(AbstractOnSubscribe.SubscriptionState<T, ObjectInputStream> state) {
                ObjectInputStream ois2 = (ObjectInputStream)state.state();
                try {
                    Serializable t = (Serializable)ois2.readObject();
                    state.onNext((Object)t);
                }
                catch (EOFException e) {
                    state.onCompleted();
                }
                catch (ClassNotFoundException e) {
                    state.onError((Throwable)e);
                }
                catch (IOException e) {
                    state.onError((Throwable)e);
                }
            }
        });
    }

    public static <T extends Serializable> Observable<T> read(final File file, final int bufferSize) {
        Func0<ObjectInputStream> resourceFactory = new Func0<ObjectInputStream>(){

            public ObjectInputStream call() {
                try {
                    return new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), bufferSize));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1 observableFactory = new Func1<ObjectInputStream, Observable<? extends T>>(){

            public Observable<? extends T> call(ObjectInputStream is) {
                return Serialized.read(is);
            }
        };
        Action1<ObjectInputStream> disposeAction = new Action1<ObjectInputStream>(){

            public void call(ObjectInputStream ois) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction, (boolean)true);
    }

    public static <T extends Serializable> Observable<T> read(File file) {
        return Serialized.read(file, 8192);
    }

    public static <T extends Serializable> Observable<T> write(Observable<T> source, final ObjectOutputStream oos) {
        return source.doOnNext(new Action1<T>(){

            public void call(T t) {
                try {
                    oos.writeObject(t);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static <T extends Serializable> Observable<T> write(final Observable<T> source, final File file, final boolean append, final int bufferSize) {
        Func0<ObjectOutputStream> resourceFactory = new Func0<ObjectOutputStream>(){

            public ObjectOutputStream call() {
                try {
                    return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file, append), bufferSize));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1 observableFactory = new Func1<ObjectOutputStream, Observable<? extends T>>(){

            public Observable<? extends T> call(ObjectOutputStream oos) {
                return Serialized.write(source, oos);
            }
        };
        Action1<ObjectOutputStream> disposeAction = new Action1<ObjectOutputStream>(){

            public void call(ObjectOutputStream oos) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction, (boolean)true);
    }

    public static <T extends Serializable> Observable<T> write(Observable<T> source, File file, boolean append) {
        return Serialized.write(source, file, append, 8192);
    }

    public static <T extends Serializable> Observable<T> write(Observable<T> source, File file) {
        return Serialized.write(source, file, false, 8192);
    }

    public static KryoBuilder kryo() {
        return Serialized.kryo(new Kryo());
    }

    public static KryoBuilder kryo(Kryo kryo) {
        return new KryoBuilder(kryo);
    }

    public static class KryoBuilder {
        private static final int DEFAULT_BUFFER_SIZE = 4096;
        private final Kryo kryo;

        private KryoBuilder(Kryo kryo) {
            this.kryo = kryo;
        }

        public <T> Observable<T> write(Observable<T> source, File file) {
            return this.write(source, file, false, 4096);
        }

        public <T> Observable<T> write(Observable<T> source, File file, boolean append) {
            return this.write(source, file, append, 4096);
        }

        public <T> Observable<T> write(final Observable<T> source, final File file, final boolean append, final int bufferSize) {
            Func0<Output> resourceFactory = new Func0<Output>(){

                public Output call() {
                    try {
                        return new Output((OutputStream)new FileOutputStream(file, append), bufferSize);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            Func1 observableFactory = new Func1<Output, Observable<? extends T>>(){

                public Observable<? extends T> call(final Output output) {
                    return source.doOnNext(new Action1<T>(){

                        public void call(T t) {
                            KryoBuilder.this.kryo.writeObject(output, t);
                        }
                    });
                }
            };
            Action1<Output> disposeAction = new Action1<Output>(){

                public void call(Output output) {
                    output.close();
                }
            };
            return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction, (boolean)true);
        }

        public <T> Observable<T> read(Class<T> cls, File file) {
            return this.read(cls, file, 4096);
        }

        public <T> Observable<T> read(final Class<T> cls, final File file, final int bufferSize) {
            Func0<Input> resourceFactory = new Func0<Input>(){

                public Input call() {
                    try {
                        return new Input((InputStream)new FileInputStream(file), bufferSize);
                    }
                    catch (FileNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            Func1 observableFactory = new Func1<Input, Observable<? extends T>>(){

                public Observable<? extends T> call(Input input) {
                    return KryoBuilder.this.read(cls, input, bufferSize);
                }
            };
            Action1<Input> disposeAction = new Action1<Input>(){

                public void call(Input input) {
                    input.close();
                }
            };
            return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction, (boolean)true);
        }

        public <T> Observable<T> read(final Class<T> cls, final Input input, int bufferSize) {
            return Observable.create((Observable.OnSubscribe)new AbstractOnSubscribe<T, Input>(){

                protected Input onSubscribe(Subscriber<? super T> subscriber) {
                    return input;
                }

                protected void next(AbstractOnSubscribe.SubscriptionState<T, Input> state) {
                    Input input2 = (Input)state.state();
                    if (input2.eof()) {
                        state.onCompleted();
                    } else {
                        Object t = KryoBuilder.this.kryo.readObject(input2, cls);
                        state.onNext(t);
                    }
                }
            });
        }
    }
}

