/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.subjects.PublishSubjectSingleSubscriber;
import rx.Notification;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Func2;
import rx.observers.SerializedSubscriber;

public class OperatorOrderedMerge<T>
implements Observable.Operator<T, T> {
    private final Observable<T> other;
    private final Func2<? super T, ? super T, Integer> comparator;
    private static final Object EMPTY_SENTINEL = new Object();

    public OperatorOrderedMerge(Observable<T> other, Func2<? super T, ? super T, Integer> comparator) {
        this.other = other;
        this.comparator = comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        PublishSubjectSingleSubscriber subject = PublishSubjectSingleSubscriber.create();
        MergeSubscriber[] subscribers = new MergeSubscriber[2];
        EventSubscriber<? super T> eventSubscriber = new EventSubscriber<T>(child, this.comparator, subscribers);
        SerializedSubscriber serializedEventSubscriber = new SerializedSubscriber(eventSubscriber);
        MergeSubscriber mainSubscriber = new MergeSubscriber(serializedEventSubscriber, 0);
        MergeSubscriber otherSubscriber = new MergeSubscriber(serializedEventSubscriber, 1);
        child.add(mainSubscriber);
        OperatorOrderedMerge operatorOrderedMerge = this;
        synchronized (operatorOrderedMerge) {
            subscribers[0] = mainSubscriber;
            subscribers[1] = otherSubscriber;
        }
        child.add(otherSubscriber);
        child.add((Subscription)serializedEventSubscriber);
        subject.unsafeSubscribe((Subscriber)serializedEventSubscriber);
        this.other.unsafeSubscribe(otherSubscriber);
        return mainSubscriber;
    }

    private static final class EventSubscriber<T>
    extends Subscriber<Event<T>> {
        private final Subscriber<? super T> child;
        private final Func2<? super T, ? super T, Integer> comparator;
        private T buffer = OperatorOrderedMerge.access$000();
        private int bufferSubscriberIndex = -1;
        private int completedCount = 0;
        private final MergeSubscriber<T>[] subscribers;

        public EventSubscriber(Subscriber<? super T> child, Func2<? super T, ? super T, Integer> comparator, MergeSubscriber<T>[] subscribers) {
            this.child = child;
            this.comparator = comparator;
            this.subscribers = subscribers;
        }

        public void onCompleted() {
        }

        public void onError(Throwable e) {
            this.child.onError(e);
        }

        public void onNext(Event<T> event) {
            if (event.notification.hasValue()) {
                Object value = event.notification.getValue();
                if (this.completedCount == 1 && this.buffer == EMPTY_SENTINEL) {
                    this.child.onNext(value);
                    this.subscribers[event.subscriberIndex].requestOne();
                } else if (this.buffer == EMPTY_SENTINEL) {
                    this.buffer = value;
                    this.bufferSubscriberIndex = event.subscriberIndex;
                } else if ((Integer)this.comparator.call(value, this.buffer) <= 0) {
                    this.child.onNext(value);
                    this.subscribers[event.subscriberIndex].requestOne();
                } else {
                    this.child.onNext(this.buffer);
                    int requestFrom = this.bufferSubscriberIndex;
                    this.buffer = value;
                    this.bufferSubscriberIndex = event.subscriberIndex;
                    this.subscribers[requestFrom].requestOne();
                }
            } else if (event.notification.isOnCompleted()) {
                ++this.completedCount;
                if (this.completedCount == 2) {
                    if (this.buffer != EMPTY_SENTINEL) {
                        this.child.onNext(this.buffer);
                        this.buffer = EMPTY_SENTINEL;
                    }
                    this.child.onCompleted();
                } else {
                    this.other(event.subscriberIndex).requestOne();
                }
            }
        }

        private MergeSubscriber<T> other(int subscriberIndex) {
            return this.subscribers[(subscriberIndex + 1) % 2];
        }
    }

    private static class MergeSubscriber<T>
    extends Subscriber<T> {
        private final Observer<Event<T>> observer;
        private final int index;

        MergeSubscriber(Observer<Event<T>> observer, int index) {
            this.observer = observer;
            this.index = index;
        }

        void requestOne() {
            this.request(1L);
        }

        public void onStart() {
            this.request(1L);
        }

        public void onCompleted() {
            this.observer.onNext(new Event(this.index, Notification.createOnCompleted()));
        }

        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        public void onNext(T t) {
            this.observer.onNext(new Event(this.index, Notification.createOnNext(t)));
        }
    }

    private static class Event<T> {
        final int subscriberIndex;
        final Notification<T> notification;

        Event(int subscriberIndex, Notification<T> notification) {
            this.subscriberIndex = subscriberIndex;
            this.notification = notification;
        }
    }
}

