/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.Transformers;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func2;
import rx.functions.Func3;

public class TransformerDecode {
    public static Observable.Transformer<byte[], String> decode(final CharsetDecoder decoder) {
        Func0<ByteBuffer> initialState = new Func0<ByteBuffer>(){

            public ByteBuffer call() {
                return null;
            }
        };
        Func3<ByteBuffer, byte[], Subscriber<String>, ByteBuffer> transition = new Func3<ByteBuffer, byte[], Subscriber<String>, ByteBuffer>(){

            public ByteBuffer call(ByteBuffer last, byte[] next, Subscriber<String> o) {
                Result result = TransformerDecode.process(next, last, false, decoder, o);
                return result.leftOver;
            }
        };
        Func2<ByteBuffer, Subscriber<String>, Boolean> completion = new Func2<ByteBuffer, Subscriber<String>, Boolean>(){

            public Boolean call(ByteBuffer last, Subscriber<String> subscriber) {
                return TransformerDecode.process(null, (ByteBuffer)last, (boolean)true, (CharsetDecoder)decoder, subscriber).canEmitFurther;
            }
        };
        return Transformers.stateMachine(initialState, transition, completion);
    }

    public static Result process(byte[] next, ByteBuffer last, boolean endOfInput, CharsetDecoder decoder, Subscriber<String> o) {
        ByteBuffer bb;
        if (o.isUnsubscribed()) {
            return new Result(null, false);
        }
        if (last != null) {
            if (next != null) {
                bb = ByteBuffer.allocate(last.remaining() + next.length);
                bb.put(last);
                bb.put(next);
                bb.flip();
            } else {
                bb = last;
            }
        } else if (next != null) {
            bb = ByteBuffer.wrap(next);
        } else {
            return new Result(null, true);
        }
        CharBuffer cb = CharBuffer.allocate((int)((float)bb.limit() * decoder.averageCharsPerByte()));
        CoderResult cr = decoder.decode(bb, cb, endOfInput);
        cb.flip();
        if (cr.isError()) {
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                o.onError((Throwable)e);
                return new Result(null, false);
            }
        }
        ByteBuffer leftOver = bb.remaining() > 0 ? bb : null;
        String string = cb.toString();
        if (!string.isEmpty()) {
            o.onNext((Object)string);
        }
        return new Result(leftOver, true);
    }

    private static final class Result {
        final ByteBuffer leftOver;
        final boolean canEmitFurther;

        Result(ByteBuffer leftOver, boolean canEmitFurther) {
            this.leftOver = leftOver;
            this.canEmitFurther = canEmitFurther;
        }
    }
}

