/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.subjects;

import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import rx.Observable;
import rx.Subscriber;
import rx.subjects.Subject;

public final class PublishSubjectSingleSubscriber<T>
extends Subject<T, T> {
    static final String ONLY_ONE_SUBSCRIPTION_IS_ALLOWED = "only one subscription is allowed";
    private final SingleSubscribeOnSubscribe<T> subscriberHolder;

    private PublishSubjectSingleSubscriber(SingleSubscribeOnSubscribe<T> onSubscribe) {
        super(onSubscribe);
        this.subscriberHolder = onSubscribe;
    }

    private PublishSubjectSingleSubscriber() {
        this(new SingleSubscribeOnSubscribe());
    }

    public static <T> PublishSubjectSingleSubscriber<T> create() {
        return new PublishSubjectSingleSubscriber<T>();
    }

    public void onCompleted() {
        if (this.subscriberHolder.subscriber != null) {
            this.subscriberHolder.subscriber.onCompleted();
        }
    }

    public void onError(Throwable e) {
        if (this.subscriberHolder.subscriber != null) {
            this.subscriberHolder.subscriber.onError(e);
        }
    }

    public void onNext(T t) {
        if (this.subscriberHolder.subscriber != null) {
            this.subscriberHolder.subscriber.onNext(t);
        }
    }

    public boolean hasObservers() {
        return this.subscriberHolder.subscriber != null;
    }

    private static class SingleSubscribeOnSubscribe<T>
    implements Observable.OnSubscribe<T> {
        volatile Subscriber<? super T> subscriber;
        private final AtomicReferenceFieldUpdater<SingleSubscribeOnSubscribe, Subscriber> SUBSCRIBER = AtomicReferenceFieldUpdater.newUpdater(SingleSubscribeOnSubscribe.class, Subscriber.class, "subscriber");

        private SingleSubscribeOnSubscribe() {
        }

        public void call(Subscriber<? super T> subscriber) {
            if (!this.SUBSCRIBER.compareAndSet(this, null, subscriber)) {
                throw new RuntimeException(PublishSubjectSingleSubscriber.ONLY_ONE_SUBSCRIPTION_IS_ALLOWED);
            }
            this.subscriber = subscriber;
        }
    }
}

