/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Transformers;
import com.github.davidmoten.rx.internal.operators.OnSubscribeReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func1;

public final class Strings {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static Func1<Object, String> TRIM = new Func1<Object, String>(){

        public String call(Object input) {
            if (input == null) {
                return null;
            }
            return input.toString().trim();
        }
    };

    public static <T> Func1<T, String> trim() {
        return TRIM;
    }

    public static Observable<String> from(Reader reader, int bufferSize) {
        return Observable.create((Observable.OnSubscribe)new OnSubscribeReader(reader, bufferSize));
    }

    public static Observable<String> from(Reader reader) {
        return Strings.from(reader, 8192);
    }

    public static Observable<String> from(InputStream is) {
        return Strings.from(new InputStreamReader(is));
    }

    public static Observable<String> from(InputStream is, Charset charset) {
        return Strings.from(new InputStreamReader(is, charset));
    }

    public static Observable<String> from(InputStream is, Charset charset, int bufferSize) {
        return Strings.from(new InputStreamReader(is, charset), bufferSize);
    }

    public static Observable<String> split(Observable<String> source, String pattern) {
        return source.compose(Transformers.split(pattern));
    }

    public static Observable<String> concat(Observable<String> source) {
        return Strings.join(source, "");
    }

    public static Observable<String> concat(Observable<String> source, String delimiter) {
        return Strings.join(source, delimiter);
    }

    public static Observable<String> strings(Observable<?> source) {
        return source.map((Func1)new Func1<Object, String>(){

            public String call(Object t) {
                return String.valueOf(t);
            }
        });
    }

    public static Observable<String> from(File file) {
        return Strings.from(file, DEFAULT_CHARSET);
    }

    public static Observable<String> from(final File file, final Charset charset) {
        Func0<Reader> resourceFactory = new Func0<Reader>(){

            public Reader call() {
                try {
                    return new InputStreamReader((InputStream)new FileInputStream(file), charset);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1<Reader, Observable<String>> observableFactory = new Func1<Reader, Observable<String>>(){

            public Observable<String> call(Reader is) {
                return Strings.from(is);
            }
        };
        Action1<Reader> disposeAction = new Action1<Reader>(){

            public void call(Reader is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction, (boolean)true);
    }

    public static Observable<String> join(Observable<String> source) {
        return Strings.join(source, "");
    }

    public static Observable<String> decode(Observable<byte[]> source, CharsetDecoder decoder) {
        return source.compose(Transformers.decode(decoder));
    }

    public static Observable<String> decode(Observable<byte[]> source, Charset charset) {
        return Strings.decode(source, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public static Observable<String> decode(Observable<byte[]> source, String charset) {
        return Strings.decode(source, Charset.forName(charset));
    }

    public static Observable<String> join(final Observable<String> source, final String delimiter) {
        return Observable.defer((Func0)new Func0<Observable<String>>(){
            final AtomicBoolean afterFirst = new AtomicBoolean(false);
            final AtomicBoolean isEmpty = new AtomicBoolean(true);

            public Observable<String> call() {
                return source.collect((Func0)new Func0<StringBuilder>(){

                    public StringBuilder call() {
                        return new StringBuilder();
                    }
                }, (Action2)new Action2<StringBuilder, String>(){

                    public void call(StringBuilder b, String s) {
                        if (!afterFirst.compareAndSet(false, true)) {
                            b.append(delimiter);
                        }
                        b.append(s);
                        isEmpty.set(false);
                    }
                }).flatMap((Func1)new Func1<StringBuilder, Observable<String>>(){

                    public Observable<String> call(StringBuilder b) {
                        if (isEmpty.get()) {
                            return Observable.empty();
                        }
                        return Observable.just((Object)b.toString());
                    }
                });
            }
        });
    }
}

