/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.rx.Transformers;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func2;
import rx.functions.Func3;

public final class TransformerStringSplit {
    public static <T> Observable.Transformer<String, String> split(final String pattern) {
        Func0<LeftOver> initialState = Functions.constant0(new LeftOver(null));
        Func3<LeftOver, String, Subscriber<String>, LeftOver> transition = new Func3<LeftOver, String, Subscriber<String>, LeftOver>(){

            public LeftOver call(LeftOver leftOver, String s, Subscriber<String> observer) {
                String[] parts = s.split(pattern, -1);
                if (leftOver.value != null) {
                    parts[0] = leftOver.value + parts[0];
                }
                for (int i = 0; i < parts.length - 1; ++i) {
                    if (observer.isUnsubscribed()) {
                        return null;
                    }
                    observer.onNext((Object)parts[i]);
                }
                return new LeftOver(parts[parts.length - 1]);
            }
        };
        Func2<LeftOver, Subscriber<String>, Boolean> completion = new Func2<LeftOver, Subscriber<String>, Boolean>(){

            public Boolean call(LeftOver leftOver, Subscriber<String> observer) {
                if (leftOver.value != null && !observer.isUnsubscribed()) {
                    observer.onNext((Object)leftOver.value);
                }
                if (!observer.isUnsubscribed()) {
                    observer.onCompleted();
                }
                return true;
            }
        };
        return Transformers.stateMachine(initialState, transition, completion);
    }

    private static class LeftOver {
        final String value;

        private LeftOver(String value) {
            this.value = value;
        }
    }
}

