/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.internal.operators.OnSubscribeInputStream;
import com.github.davidmoten.rx.util.ZippedEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import rx.Observable;
import rx.Observer;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.SyncOnSubscribe;

public final class Bytes {
    public static Observable<byte[]> from(InputStream is, int size) {
        return Observable.create((Observable.OnSubscribe)new OnSubscribeInputStream(is, size));
    }

    public static Observable<byte[]> from(InputStream is) {
        return Bytes.from(is, 8192);
    }

    public static Observable<ZippedEntry> unzip(final File file) {
        Func0<ZipInputStream> resourceFactory = new Func0<ZipInputStream>(){

            public ZipInputStream call() {
                try {
                    return new ZipInputStream(new FileInputStream(file));
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Func1<ZipInputStream, Observable<ZippedEntry>> observableFactory = new Func1<ZipInputStream, Observable<ZippedEntry>>(){

            public Observable<ZippedEntry> call(ZipInputStream zis) {
                return Bytes.unzip(zis);
            }
        };
        Action1<ZipInputStream> disposeAction = new Action1<ZipInputStream>(){

            public void call(ZipInputStream zis) {
                try {
                    zis.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Observable.using((Func0)resourceFactory, (Func1)observableFactory, (Action1)disposeAction);
    }

    public static Observable<ZippedEntry> unzip(InputStream is) {
        return Bytes.unzip(new ZipInputStream(is));
    }

    public static Observable<ZippedEntry> unzip(final ZipInputStream zis) {
        return Observable.create((Observable.OnSubscribe)new SyncOnSubscribe<ZipInputStream, ZippedEntry>(){

            protected ZipInputStream generateState() {
                return zis;
            }

            protected ZipInputStream next(ZipInputStream zis2, Observer<? super ZippedEntry> observer) {
                try {
                    ZipEntry zipEntry = zis2.getNextEntry();
                    if (zipEntry != null) {
                        observer.onNext((Object)new ZippedEntry(zipEntry, zis2));
                    } else {
                        zis2.close();
                        observer.onCompleted();
                    }
                }
                catch (IOException e) {
                    observer.onError((Throwable)e);
                }
                return zis2;
            }
        });
    }
}

