/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Actions;
import com.github.davidmoten.rx.Functions;
import com.github.davidmoten.util.Optional;
import com.github.davidmoten.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.schedulers.Schedulers;

public final class RetryWhen {
    private static final long NO_MORE_DELAYS = -1L;
    private static Func2<Throwable, Long, ErrorAndDuration> TO_ERROR_AND_DURATION = new Func2<Throwable, Long, ErrorAndDuration>(){

        public ErrorAndDuration call(Throwable throwable, Long durationMs) {
            return new ErrorAndDuration(throwable, durationMs);
        }
    };

    private static Func1<Observable<? extends Throwable>, Observable<?>> notificationHandler(Observable<Long> delays, Scheduler scheduler, Action1<? super ErrorAndDuration> action, List<Class<? extends Throwable>> retryExceptions, List<Class<? extends Throwable>> failExceptions, Func1<? super Throwable, Boolean> exceptionPredicate) {
        Func1<ErrorAndDuration, Observable<ErrorAndDuration>> checkExceptions = RetryWhen.createExceptionChecker(retryExceptions, failExceptions, exceptionPredicate);
        return RetryWhen.createNotificationHandler(delays, scheduler, action, checkExceptions);
    }

    private static Func1<Observable<? extends Throwable>, Observable<?>> createNotificationHandler(final Observable<Long> delays, final Scheduler scheduler, final Action1<? super ErrorAndDuration> action, final Func1<ErrorAndDuration, Observable<ErrorAndDuration>> checkExceptions) {
        return new Func1<Observable<? extends Throwable>, Observable<?>>(){

            public Observable<ErrorAndDuration> call(Observable<? extends Throwable> errors) {
                return errors.zipWith(delays.concatWith(Observable.just((Object)-1L)), TO_ERROR_AND_DURATION).flatMap(checkExceptions).doOnNext(RetryWhen.callActionExceptForLast((Action1<? super ErrorAndDuration>)action)).flatMap(RetryWhen.delay(scheduler));
            }
        };
    }

    private static Action1<ErrorAndDuration> callActionExceptForLast(final Action1<? super ErrorAndDuration> action) {
        return new Action1<ErrorAndDuration>(){

            public void call(ErrorAndDuration e) {
                if (e.durationMs() != -1L) {
                    action.call((Object)e);
                }
            }
        };
    }

    private static Func1<ErrorAndDuration, Observable<ErrorAndDuration>> createExceptionChecker(final List<Class<? extends Throwable>> retryExceptions, final List<Class<? extends Throwable>> failExceptions, final Func1<? super Throwable, Boolean> exceptionPredicate) {
        return new Func1<ErrorAndDuration, Observable<ErrorAndDuration>>(){

            public Observable<ErrorAndDuration> call(ErrorAndDuration e) {
                if (!((Boolean)exceptionPredicate.call((Object)e.throwable())).booleanValue()) {
                    return Observable.error((Throwable)e.throwable());
                }
                for (Class cls : failExceptions) {
                    if (!e.throwable().getClass().isAssignableFrom(cls)) continue;
                    return Observable.error((Throwable)e.throwable());
                }
                if (retryExceptions.size() > 0) {
                    for (Class cls : retryExceptions) {
                        if (!e.throwable().getClass().isAssignableFrom(cls)) continue;
                        return Observable.just((Object)e);
                    }
                    return Observable.error((Throwable)e.throwable());
                }
                return Observable.just((Object)e);
            }
        };
    }

    private static Func1<ErrorAndDuration, Observable<ErrorAndDuration>> delay(final Scheduler scheduler) {
        return new Func1<ErrorAndDuration, Observable<ErrorAndDuration>>(){

            public Observable<ErrorAndDuration> call(ErrorAndDuration e) {
                if (e.durationMs() == -1L) {
                    return Observable.error((Throwable)e.throwable());
                }
                return Observable.timer((long)e.durationMs(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler).map(Functions.constant(e));
            }
        };
    }

    public static Builder retryWhenInstanceOf(Class<? extends Throwable> ... classes) {
        return new Builder().retryWhenInstanceOf(classes);
    }

    public static Builder failWhenInstanceOf(Class<? extends Throwable> ... classes) {
        return new Builder().failWhenInstanceOf(classes);
    }

    public static Builder retryIf(Func1<Throwable, Boolean> predicate) {
        return new Builder().retryIf(predicate);
    }

    public static Builder delays(Observable<Long> delays, TimeUnit unit) {
        return new Builder().delays(delays, unit);
    }

    public static Builder delay(Long delay, TimeUnit unit) {
        return new Builder().delay(delay, unit);
    }

    public static Builder maxRetries(int maxRetries) {
        return new Builder().maxRetries(maxRetries);
    }

    public static Builder scheduler(Scheduler scheduler) {
        return new Builder().scheduler(scheduler);
    }

    public Builder action(Action1<? super ErrorAndDuration> action) {
        return new Builder().action(action);
    }

    public static Builder exponentialBackoff(long firstDelay, TimeUnit unit, double factor) {
        return new Builder().exponentialBackoff(firstDelay, unit, factor);
    }

    public static Builder exponentialBackoff(long firstDelay, TimeUnit unit) {
        return new Builder().exponentialBackoff(firstDelay, unit);
    }

    public static final class ErrorAndDuration {
        private final Throwable throwable;
        private final long durationMs;

        public ErrorAndDuration(Throwable throwable, long durationMs) {
            this.throwable = throwable;
            this.durationMs = durationMs;
        }

        public Throwable throwable() {
            return this.throwable;
        }

        public long durationMs() {
            return this.durationMs;
        }
    }

    public static final class Builder {
        private final List<Class<? extends Throwable>> retryExceptions = new ArrayList<Class<? extends Throwable>>();
        private final List<Class<? extends Throwable>> failExceptions = new ArrayList<Class<? extends Throwable>>();
        private Func1<? super Throwable, Boolean> exceptionPredicate = Functions.alwaysTrue();
        private Observable<Long> delays = Observable.just((Object)0L).repeat();
        private Optional<Integer> maxRetries = Optional.absent();
        private Optional<Scheduler> scheduler = Optional.of(Schedulers.computation());
        private Action1<? super ErrorAndDuration> action = Actions.doNothing1();

        private Builder() {
        }

        public Builder retryWhenInstanceOf(Class<? extends Throwable> ... classes) {
            this.retryExceptions.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder failWhenInstanceOf(Class<? extends Throwable> ... classes) {
            this.failExceptions.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder retryIf(Func1<Throwable, Boolean> predicate) {
            this.exceptionPredicate = predicate;
            return this;
        }

        public Builder delays(Observable<Long> delays, TimeUnit unit) {
            this.delays = delays.map(Builder.toMillis(unit));
            return this;
        }

        public Builder delay(Long delay, TimeUnit unit) {
            this.delays = Observable.just((Object)delay).map(Builder.toMillis(unit));
            return this;
        }

        private static Func1<Long, Long> toMillis(final TimeUnit unit) {
            return new Func1<Long, Long>(){

                public Long call(Long t) {
                    return unit.toMillis(t);
                }
            };
        }

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = Optional.of(maxRetries);
            return this;
        }

        public Builder scheduler(Scheduler scheduler) {
            this.scheduler = Optional.of(scheduler);
            return this;
        }

        public Builder action(Action1<? super ErrorAndDuration> action) {
            this.action = action;
            return this;
        }

        public Builder exponentialBackoff(final long firstDelay, final TimeUnit unit, final double factor) {
            this.delays = Observable.range((int)1, (int)Integer.MAX_VALUE).map((Func1)new Func1<Integer, Long>(){

                public Long call(Integer n) {
                    return Math.round(Math.pow(factor, n - 1) * (double)unit.toMillis(firstDelay));
                }
            });
            return this;
        }

        public Builder exponentialBackoff(long firstDelay, TimeUnit unit) {
            return this.exponentialBackoff(firstDelay, unit, 2.0);
        }

        public Func1<Observable<? extends Throwable>, Observable<?>> build() {
            Preconditions.checkNotNull(this.delays);
            if (this.maxRetries.isPresent()) {
                this.delays = this.delays.take(this.maxRetries.get().intValue());
            }
            return RetryWhen.notificationHandler((Observable<Long>)this.delays, this.scheduler.get(), (Action1<? super ErrorAndDuration>)this.action, this.retryExceptions, this.failExceptions, (Func1<? super Throwable, Boolean>)this.exceptionPredicate);
        }
    }
}

