/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import rx.Observable;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func0;
import rx.functions.Func2;

public final class OperatorCollectWhile<R, T>
implements Observable.Operator<R, T> {
    private final Func0<? extends R> factory;
    private final Func2<? super R, ? super T, ? extends R> collector;
    private final Func2<? super R, ? super T, Boolean> condition;

    public OperatorCollectWhile(Func0<? extends R> factory, Func2<? super R, ? super T, ? extends R> collector, Func2<? super R, ? super T, Boolean> condition) {
        this.factory = factory;
        this.collector = collector;
        this.condition = condition;
    }

    public Subscriber<? super T> call(final Subscriber<? super R> child) {
        return new Subscriber<T>(child){
            R collection;

            public void onCompleted() {
                if (this.collection != null) {
                    Object c = this.collection;
                    this.collection = null;
                    child.onNext(c);
                    if (!child.isUnsubscribed()) {
                        child.onCompleted();
                    }
                }
            }

            public void onError(Throwable e) {
                this.collection = null;
                child.onError(e);
            }

            public void onNext(T t) {
                try {
                    if (this.collection == null) {
                        this.collection = OperatorCollectWhile.this.factory.call();
                    }
                    if (((Boolean)OperatorCollectWhile.this.condition.call(this.collection, t)).booleanValue()) {
                        this.collection = OperatorCollectWhile.this.collector.call(this.collection, t);
                        this.request(1L);
                    } else {
                        Object c = this.collection;
                        this.collection = null;
                        if (!child.isUnsubscribed()) {
                            child.onNext(c);
                        }
                    }
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal((Throwable)e);
                    this.onError(OnErrorThrowable.addValueAsLastCause((Throwable)e, t));
                }
            }
        };
    }
}

