/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.MissingBackpressureException;
import rx.functions.Func1;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.atomic.SpscAtomicArrayQueue;
import rx.internal.util.unsafe.SpscArrayQueue;
import rx.internal.util.unsafe.UnsafeAccess;

public final class OperatorBufferPredicateBoundary<T>
implements Observable.Transformer<T, List<T>> {
    final Func1<? super T, Boolean> predicate;
    final int prefetch;
    final int capacityHint;
    final boolean after;

    public OperatorBufferPredicateBoundary(Func1<? super T, Boolean> predicate, int prefetch, int capacityHint, boolean after) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        if (capacityHint <= 0) {
            throw new IllegalArgumentException("capacityHint > 0 required but it was " + capacityHint);
        }
        this.predicate = predicate;
        this.prefetch = prefetch;
        this.capacityHint = capacityHint;
        this.after = after;
    }

    public Observable<List<T>> call(Observable<T> source) {
        return source.lift(new Observable.Operator<List<T>, T>(){

            public Subscriber<? super T> call(Subscriber<? super List<T>> child) {
                final BoundedSubscriber parent = OperatorBufferPredicateBoundary.this.after ? new BoundedAfterSubscriber(child, OperatorBufferPredicateBoundary.this.capacityHint, OperatorBufferPredicateBoundary.this.predicate, OperatorBufferPredicateBoundary.this.prefetch) : new BoundedBeforeSubscriber(child, OperatorBufferPredicateBoundary.this.capacityHint, OperatorBufferPredicateBoundary.this.predicate, OperatorBufferPredicateBoundary.this.prefetch);
                child.add(parent);
                child.setProducer(new Producer(){

                    public void request(long n) {
                        parent.requestMore(n);
                    }
                });
                return parent;
            }
        });
    }

    static final class BoundedBeforeSubscriber<T>
    extends BoundedSubscriber<T> {
        public BoundedBeforeSubscriber(Subscriber<? super List<T>> actual, int capacityHint, Func1<? super T, Boolean> predicate, int prefetch) {
            super(actual, capacityHint, predicate, prefetch);
        }

        @Override
        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber localSubscriber = this.actual;
            Queue localQueue = this.queue;
            int missed = 1;
            do {
                Throwable exception;
                boolean mainDone;
                long localRequested = this.requested.get();
                long localEmission = 0L;
                long localConsumption = 0L;
                ArrayList<Object> localBuffer = this.buffer;
                while (localEmission != localRequested) {
                    boolean emit;
                    boolean empty;
                    if (localSubscriber.isUnsubscribed()) {
                        return;
                    }
                    mainDone = this.done;
                    if (mainDone && (exception = this.error) != null) {
                        this.buffer = null;
                        localSubscriber.onError(exception);
                        return;
                    }
                    Object o = localQueue.poll();
                    boolean bl = empty = o == null;
                    if (mainDone && empty) {
                        this.buffer = null;
                        if (!localBuffer.isEmpty()) {
                            localSubscriber.onNext((Object)localBuffer);
                        }
                        localSubscriber.onCompleted();
                        return;
                    }
                    if (empty) break;
                    Object value = NotificationLite.getValue(o);
                    try {
                        emit = (Boolean)this.predicate.call(value);
                    }
                    catch (Throwable ex) {
                        this.unsubscribe();
                        this.buffer = null;
                        Exceptions.throwOrReport((Throwable)ex, (Observer)localSubscriber, (Object)value);
                        return;
                    }
                    if (emit && !localBuffer.isEmpty()) {
                        localSubscriber.onNext((Object)localBuffer);
                        this.buffer = localBuffer = new ArrayList<Object>(this.capacityHint);
                        ++localEmission;
                    }
                    localBuffer.add(value);
                    ++localConsumption;
                }
                if (localEmission == localRequested) {
                    if (localSubscriber.isUnsubscribed()) {
                        return;
                    }
                    mainDone = this.done;
                    if (mainDone) {
                        exception = this.error;
                        if (exception != null) {
                            this.buffer = null;
                            localSubscriber.onError(exception);
                            return;
                        }
                        if (localQueue.isEmpty() && localBuffer.isEmpty()) {
                            this.buffer = null;
                            localSubscriber.onCompleted();
                            return;
                        }
                    }
                }
                if (localEmission != 0L) {
                    BackpressureUtils.produced((AtomicLong)this.requested, (long)localEmission);
                }
                if (localConsumption == 0L) continue;
                long produced = this.upstreamConsumed + localConsumption;
                if (produced >= (long)this.limit) {
                    this.upstreamConsumed = 0L;
                    this.request(produced);
                    continue;
                }
                this.upstreamConsumed = produced;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BoundedAfterSubscriber<T>
    extends BoundedSubscriber<T> {
        public BoundedAfterSubscriber(Subscriber<? super List<T>> actual, int capacityHint, Func1<? super T, Boolean> predicate, int prefetch) {
            super(actual, capacityHint, predicate, prefetch);
        }

        @Override
        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            Subscriber localSubscriber = this.actual;
            Queue localQueue = this.queue;
            int missed = 1;
            do {
                Throwable exception;
                boolean mainDone;
                long localRequested = this.requested.get();
                long localEmission = 0L;
                long localConsumption = 0L;
                ArrayList<Object> localBuffer = this.buffer;
                while (localEmission != localRequested) {
                    boolean emit;
                    boolean empty;
                    if (localSubscriber.isUnsubscribed()) {
                        return;
                    }
                    mainDone = this.done;
                    if (mainDone && (exception = this.error) != null) {
                        this.buffer = null;
                        localSubscriber.onError(exception);
                        return;
                    }
                    Object notification = localQueue.poll();
                    boolean bl = empty = notification == null;
                    if (mainDone && empty) {
                        this.buffer = null;
                        if (!localBuffer.isEmpty()) {
                            localSubscriber.onNext((Object)localBuffer);
                        }
                        localSubscriber.onCompleted();
                        return;
                    }
                    if (empty) break;
                    Object value = NotificationLite.getValue(notification);
                    localBuffer.add(value);
                    ++localConsumption;
                    try {
                        emit = (Boolean)this.predicate.call(value);
                    }
                    catch (Throwable ex) {
                        this.unsubscribe();
                        this.buffer = null;
                        Exceptions.throwOrReport((Throwable)ex, (Observer)localSubscriber, (Object)value);
                        return;
                    }
                    if (!emit) continue;
                    localSubscriber.onNext((Object)localBuffer);
                    this.buffer = localBuffer = new ArrayList<Object>(this.capacityHint);
                    ++localEmission;
                }
                if (localEmission == localRequested) {
                    if (localSubscriber.isUnsubscribed()) {
                        return;
                    }
                    mainDone = this.done;
                    if (mainDone) {
                        exception = this.error;
                        if (exception != null) {
                            this.buffer = null;
                            localSubscriber.onError(exception);
                            return;
                        }
                        if (localQueue.isEmpty() && localBuffer.isEmpty()) {
                            this.buffer = null;
                            localSubscriber.onCompleted();
                            return;
                        }
                    }
                }
                if (localEmission != 0L) {
                    BackpressureUtils.produced((AtomicLong)this.requested, (long)localEmission);
                }
                if (localConsumption == 0L) continue;
                long p = this.upstreamConsumed + localConsumption;
                if (p >= (long)this.limit) {
                    this.upstreamConsumed = 0L;
                    this.request(p);
                    continue;
                }
                this.upstreamConsumed = p;
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static abstract class BoundedSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super List<T>> actual;
        final int capacityHint;
        final Func1<? super T, Boolean> predicate;
        final Queue<Object> queue;
        final AtomicLong requested;
        final AtomicInteger wip;
        final int limit;
        List<T> buffer;
        long upstreamConsumed;
        volatile boolean done;
        Throwable error;

        public BoundedSubscriber(Subscriber<? super List<T>> actual, int capacityHint, Func1<? super T, Boolean> predicate, int prefetch) {
            this.actual = actual;
            this.capacityHint = capacityHint;
            this.predicate = predicate;
            Object q = UnsafeAccess.isUnsafeAvailable() ? new SpscArrayQueue(prefetch) : new SpscAtomicArrayQueue(prefetch);
            this.queue = q;
            this.buffer = new ArrayList<T>(capacityHint);
            this.requested = new AtomicLong();
            this.wip = new AtomicInteger();
            this.limit = prefetch - (prefetch >> 2);
            if (prefetch == Integer.MAX_VALUE) {
                this.request(Long.MAX_VALUE);
            } else {
                this.request(prefetch);
            }
        }

        public void onNext(T t) {
            if (!this.queue.offer(NotificationLite.next(t))) {
                this.unsubscribe();
                this.onError((Throwable)new MissingBackpressureException());
            } else {
                this.drain();
            }
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        void requestMore(long n) {
            if (n > 0L) {
                BackpressureUtils.getAndAddRequest((AtomicLong)this.requested, (long)n);
                this.drain();
            } else if (n < 0L) {
                throw new IllegalArgumentException("n >= 0 required but it was " + n);
            }
        }

        abstract void drain();
    }
}

