/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import com.github.davidmoten.rx.buffertofile.DataSerializer;
import com.github.davidmoten.rx.internal.operators.FileBasedSPSCQueueMemoryMappedReaderWriter;
import com.github.davidmoten.rx.internal.operators.QueueWithSubscription;
import com.github.davidmoten.util.Preconditions;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import rx.functions.Func0;

public final class FileBasedSPSCQueueMemoryMapped<T>
implements QueueWithSubscription<T> {
    private final Queue<FileBasedSPSCQueueMemoryMappedReaderWriter<T>> inactive = new LinkedList<FileBasedSPSCQueueMemoryMappedReaderWriter<T>>();
    private final Deque<FileBasedSPSCQueueMemoryMappedReaderWriter<T>> toRead = new ArrayDeque<FileBasedSPSCQueueMemoryMappedReaderWriter<T>>();
    private final Object lock = new Object();
    private final Func0<File> factory;
    private final int size;
    private FileBasedSPSCQueueMemoryMappedReaderWriter<T> reader;
    private FileBasedSPSCQueueMemoryMappedReaderWriter<T> writer;
    private final AtomicInteger wip = new AtomicInteger();
    private volatile boolean unsubscribed = false;
    private final AtomicLong count = new AtomicLong();
    private final DataSerializer<T> serializer;

    public FileBasedSPSCQueueMemoryMapped(Func0<File> factory, int size, DataSerializer<T> serializer) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(serializer);
        this.factory = factory;
        this.size = size;
        this.serializer = serializer;
        File file = (File)factory.call();
        this.writer = new FileBasedSPSCQueueMemoryMappedReaderWriter<T>(file, size, serializer);
        this.reader = this.writer.openForWrite().openForRead();
        this.wip.lazySet(0);
    }

    public void unsubscribe() {
        this.wip.incrementAndGet();
        this.unsubscribed = true;
        this.checkUnsubscribe();
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean offer(T t) {
        try {
            this.wip.incrementAndGet();
            if (this.unsubscribed) {
                boolean bl = true;
                return bl;
            }
            if (!this.writer.offer(t)) {
                FileBasedSPSCQueueMemoryMappedReaderWriter<T> nextWriter;
                Object object = this.lock;
                synchronized (object) {
                    nextWriter = this.inactive.poll();
                    if (nextWriter == null) {
                        nextWriter = new FileBasedSPSCQueueMemoryMappedReaderWriter<T>((File)this.factory.call(), this.size, this.serializer);
                    }
                    this.toRead.offerLast(nextWriter);
                    nextWriter.openForWrite();
                }
                this.writer = nextWriter;
                boolean bl = this.writer.offer(t);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.checkUnsubscribe();
            this.count.incrementAndGet();
        }
    }

    private void checkUnsubscribe() {
        if (this.unsubscribed & this.wip.decrementAndGet() == 0) {
            this.close();
        }
    }

    private void close() {
        this.writer.close();
        this.reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized T poll() {
        T value = null;
        try {
            this.wip.incrementAndGet();
            if (this.unsubscribed) {
                T t = null;
                return t;
            }
            T t = value = (T)this.reader.poll();
            return t;
        }
        catch (FileBasedSPSCQueueMemoryMappedReaderWriter.EOFRuntimeException e) {
            FileBasedSPSCQueueMemoryMappedReaderWriter<T> nextReader;
            Object object = this.lock;
            synchronized (object) {
                block13: {
                    if (!this.toRead.isEmpty()) break block13;
                    T t = null;
                    return t;
                }
                nextReader = this.toRead.pollFirst();
                this.reader.closeForRead();
                this.inactive.offer(this.reader);
            }
            this.reader = nextReader;
            this.reader.openForRead();
            value = this.reader.poll();
            object = value;
            return (T)object;
        }
        finally {
            this.checkUnsubscribe();
            if (value != null) {
                this.count.decrementAndGet();
            }
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.count.get() == 0L;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(T e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T element() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T peek() {
        throw new UnsupportedOperationException();
    }
}

