/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.guavamini.Optional;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx.Strings;
import com.github.davidmoten.rx.internal.operators.OnSubscribeWatchServiceEvents;
import com.github.davidmoten.rx.internal.operators.OperatorFileTailer;
import com.github.davidmoten.rx.util.BackpressureStrategy;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observables.GroupedObservable;
import rx.schedulers.Schedulers;

public final class FileObservable {
    public static final int DEFAULT_MAX_BYTES_PER_EMISSION = 8192;
    private static final Func1<WatchService, Observable<WatchEvent<?>>> TO_WATCH_EVENTS = new Func1<WatchService, Observable<WatchEvent<?>>>(){

        public Observable<WatchEvent<?>> call(WatchService watchService) {
            return FileObservable.from(watchService);
        }
    };
    private static Func1<Object, Boolean> IS_MODIFY_OR_OVERFLOW = new Func1<Object, Boolean>(){

        public Boolean call(Object event) {
            if (event instanceof WatchEvent) {
                WatchEvent w = (WatchEvent)event;
                String kind = w.kind().name();
                if (kind.equals(StandardWatchEventKinds.ENTRY_MODIFY.name()) || kind.equals(StandardWatchEventKinds.OVERFLOW.name())) {
                    return true;
                }
                return false;
            }
            return false;
        }
    };

    private FileObservable() {
    }

    public static final Observable<byte[]> tailFile(File file, long startPosition, long sampleTimeMs, int chunkSize) {
        Preconditions.checkNotNull((Object)file);
        Observable events = FileObservable.from(file, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW).cast(Object.class).startWith(new Object());
        return FileObservable.tailFile(file, startPosition, sampleTimeMs, chunkSize, events);
    }

    public static final Observable<byte[]> tailFile(File file, long startPosition, long sampleTimeMs, int chunkSize, Observable<?> events) {
        Preconditions.checkNotNull((Object)file);
        return FileObservable.sampleModifyOrOverflowEventsOnly(events, sampleTimeMs).lift((Observable.Operator)new OperatorFileTailer(file, startPosition, chunkSize));
    }

    public static final Observable<String> tailTextFile(File file, long startPosition, long sampleTimeMs, Charset charset) {
        return FileObservable.toLines(FileObservable.tailFile(file, startPosition, sampleTimeMs, 8192), charset);
    }

    public static final Observable<String> tailTextFile(File file, long startPosition, int chunkSize, Charset charset, Observable<?> events) {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)charset);
        Preconditions.checkNotNull(events);
        return FileObservable.toLines((Observable<byte[]>)events.lift((Observable.Operator)new OperatorFileTailer(file, startPosition, chunkSize)).onBackpressureBuffer(), charset);
    }

    public static final Observable<WatchEvent<?>> from(WatchService watchService, Scheduler scheduler, long pollDuration, TimeUnit pollDurationUnit, long pollInterval, TimeUnit pollIntervalUnit, BackpressureStrategy backpressureStrategy) {
        Preconditions.checkNotNull((Object)watchService);
        Preconditions.checkNotNull((Object)scheduler);
        Preconditions.checkNotNull((Object)((Object)pollDurationUnit));
        Preconditions.checkNotNull((Object)backpressureStrategy);
        Observable o = Observable.create((Observable.OnSubscribe)new OnSubscribeWatchServiceEvents(watchService, scheduler, pollDuration, pollDurationUnit, pollInterval, pollIntervalUnit));
        if (backpressureStrategy == BackpressureStrategy.BUFFER) {
            return o.onBackpressureBuffer();
        }
        if (backpressureStrategy == BackpressureStrategy.DROP) {
            return o.onBackpressureDrop();
        }
        if (backpressureStrategy == BackpressureStrategy.LATEST) {
            return o.onBackpressureLatest();
        }
        throw new RuntimeException("unrecognized backpressureStrategy " + backpressureStrategy);
    }

    public static final Observable<WatchEvent<?>> from(WatchService watchService) {
        return FileObservable.from(watchService, Schedulers.trampoline(), Long.MAX_VALUE, TimeUnit.MILLISECONDS, 0L, TimeUnit.SECONDS, BackpressureStrategy.BUFFER);
    }

    @SafeVarargs
    public static final Observable<WatchEvent<?>> from(File file, WatchEvent.Kind<?> ... kinds) {
        return FileObservable.from(file, null, kinds);
    }

    public static final Observable<WatchEvent<?>> from(File file, List<WatchEvent.Kind<?>> kinds) {
        return FileObservable.from(file, null, kinds.toArray(new WatchEvent.Kind[0]));
    }

    public static final Observable<WatchEvent<?>> from(File file, final Action0 onWatchStarted, WatchEvent.Kind<?> ... kinds) {
        return FileObservable.watchService(file, kinds).doOnNext((Action1)new Action1<WatchService>(){

            public void call(WatchService w) {
                if (onWatchStarted != null) {
                    onWatchStarted.call();
                }
            }
        }).flatMap(TO_WATCH_EVENTS).filter(FileObservable.onlyRelatedTo(file));
    }

    @SafeVarargs
    public static final Observable<WatchService> watchService(final File file, final WatchEvent.Kind<?> ... kinds) {
        return Observable.defer((Func0)new Func0<Observable<WatchService>>(){

            public Observable<WatchService> call() {
                try {
                    Path path = FileObservable.getBasePath(file);
                    WatchService watchService = path.getFileSystem().newWatchService();
                    path.register(watchService, kinds);
                    return Observable.just((Object)watchService);
                }
                catch (Exception e) {
                    return Observable.error((Throwable)e);
                }
            }
        });
    }

    private static final Path getBasePath(File file) {
        Path path = file.exists() && file.isDirectory() ? Paths.get(file.toURI()) : Paths.get(file.getParentFile().toURI());
        return path;
    }

    private static final Func1<WatchEvent<?>, Boolean> onlyRelatedTo(final File file) {
        return new Func1<WatchEvent<?>, Boolean>(){

            public Boolean call(WatchEvent<?> event) {
                boolean ok;
                if (file.isDirectory()) {
                    ok = true;
                } else if (StandardWatchEventKinds.OVERFLOW.equals(event.kind())) {
                    ok = true;
                } else {
                    Object context = event.context();
                    if (context != null && context instanceof Path) {
                        Path p = (Path)context;
                        Path basePath = FileObservable.getBasePath(file);
                        File pFile = new File(basePath.toFile(), p.toString());
                        ok = pFile.getAbsolutePath().equals(file.getAbsolutePath());
                    } else {
                        ok = false;
                    }
                }
                return ok;
            }
        };
    }

    private static Observable<String> toLines(Observable<byte[]> bytes, Charset charset) {
        return Strings.split((Observable)Strings.decode(bytes, (Charset)charset), (String)"\n");
    }

    private static Observable<Object> sampleModifyOrOverflowEventsOnly(Observable<?> events, long sampleTimeMs) {
        return events.groupBy(IS_MODIFY_OR_OVERFLOW).flatMap(FileObservable.sampleIfTrue(sampleTimeMs));
    }

    private static Func1<GroupedObservable<Boolean, ?>, Observable<?>> sampleIfTrue(final long sampleTimeMs) {
        return new Func1<GroupedObservable<Boolean, ?>, Observable<?>>(){

            public Observable<?> call(GroupedObservable<Boolean, ?> group) {
                if (((Boolean)group.getKey()).booleanValue()) {
                    return group.sample(sampleTimeMs, TimeUnit.MILLISECONDS);
                }
                return group;
            }
        };
    }

    public static WatchEventsBuilder from(File file) {
        return new WatchEventsBuilder(file);
    }

    public static TailerBuilder tailer() {
        return new TailerBuilder();
    }

    public static final class TailerBuilder {
        private File file = null;
        private long startPosition = 0L;
        private long sampleTimeMs = 500L;
        private int chunkSize = 8192;
        private Charset charset = Charset.defaultCharset();
        private Observable<?> source = null;
        private Action0 onWatchStarted = new Action0(){

            public void call() {
            }
        };

        private TailerBuilder() {
        }

        public TailerBuilder file(File file) {
            this.file = file;
            return this;
        }

        public TailerBuilder file(String filename) {
            return this.file(new File(filename));
        }

        public TailerBuilder onWatchStarted(Action0 onWatchStarted) {
            this.onWatchStarted = onWatchStarted;
            return this;
        }

        public TailerBuilder startPosition(long startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public TailerBuilder sampleTimeMs(long sampleTimeMs) {
            this.sampleTimeMs = sampleTimeMs;
            return this;
        }

        public TailerBuilder chunkSize(int chunkSize) {
            this.chunkSize = chunkSize;
            return this;
        }

        public TailerBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public TailerBuilder charset(String charset) {
            return this.charset(Charset.forName(charset));
        }

        public TailerBuilder utf8() {
            return this.charset("UTF-8");
        }

        public TailerBuilder source(Observable<?> source) {
            this.source = source;
            return this;
        }

        public Observable<byte[]> tail() {
            return FileObservable.tailFile(this.file, this.startPosition, this.sampleTimeMs, this.chunkSize, this.getSource());
        }

        public Observable<String> tailText() {
            return FileObservable.tailTextFile(this.file, this.startPosition, this.chunkSize, this.charset, this.getSource());
        }

        private Observable<?> getSource() {
            if (this.source == null) {
                return FileObservable.from(this.file, this.onWatchStarted, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
            }
            return this.source;
        }
    }

    public static final class WatchEventsBuilder {
        private final File file;
        private Optional<Scheduler> scheduler = Optional.absent();
        private long pollInterval = 0L;
        private TimeUnit pollIntervalUnit = TimeUnit.MILLISECONDS;
        private Optional<Long> pollDuration = Optional.absent();
        private TimeUnit pollDurationUnit = TimeUnit.MILLISECONDS;
        private final List<WatchEvent.Kind<?>> kinds = new ArrayList();
        private BackpressureStrategy backpressureStrategy = BackpressureStrategy.BUFFER;

        private WatchEventsBuilder(File file) {
            this.file = file;
        }

        public WatchEventsBuilder scheduler(Scheduler scheduler) {
            this.scheduler = Optional.of((Object)scheduler);
            return this;
        }

        public WatchEventsBuilder pollInterval(long interval, TimeUnit unit) {
            this.pollInterval = interval;
            this.pollIntervalUnit = unit;
            if (!this.pollDuration.isPresent()) {
                this.pollDuration = Optional.of((Object)0L);
            }
            return this;
        }

        public WatchEventsBuilder pollDuration(long duration, TimeUnit unit) {
            this.pollDuration = Optional.of((Object)duration);
            this.pollDurationUnit = unit;
            return this;
        }

        public WatchEventsBuilder kind(WatchEvent.Kind<?> kind) {
            this.kinds.add(kind);
            return this;
        }

        public WatchEventsBuilder kinds(WatchEvent.Kind<?> ... kinds) {
            for (WatchEvent.Kind<?> kind : kinds) {
                this.kinds.add(kind);
            }
            return this;
        }

        public WatchEventsBuilder onBackpressure(BackpressureStrategy strategy) {
            this.backpressureStrategy = strategy;
            return this;
        }

        public Observable<WatchEvent<?>> events() {
            return FileObservable.watchService(this.file, this.kinds.toArray(new WatchEvent.Kind[0])).flatMap(new Func1<WatchService, Observable<WatchEvent<?>>>(){

                public Observable<WatchEvent<?>> call(WatchService watchService) {
                    if (!WatchEventsBuilder.this.scheduler.isPresent()) {
                        if (!WatchEventsBuilder.this.pollDuration.isPresent() || (Long)WatchEventsBuilder.this.pollDuration.get() == 0L) {
                            WatchEventsBuilder.this.scheduler = Optional.of((Object)Schedulers.computation());
                        } else {
                            WatchEventsBuilder.this.scheduler = Optional.of((Object)Schedulers.io());
                        }
                    }
                    return FileObservable.from(watchService, (Scheduler)WatchEventsBuilder.this.scheduler.get(), (Long)WatchEventsBuilder.this.pollDuration.or((Object)Long.MAX_VALUE), WatchEventsBuilder.this.pollDurationUnit, WatchEventsBuilder.this.pollInterval, WatchEventsBuilder.this.pollIntervalUnit, WatchEventsBuilder.this.backpressureStrategy);
                }
            });
        }
    }
}

