/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public final class OnSubscribeWatchServiceEvents
implements Observable.OnSubscribe<WatchEvent<?>> {
    private final Scheduler scheduler;
    private final WatchService watchService;
    private final long pollDurationMs;
    private final long pollIntervalMs;

    public OnSubscribeWatchServiceEvents(WatchService watchService, Scheduler scheduler, long pollDuration, TimeUnit pollDurationUnit, long pollInterval, TimeUnit pollIntervalUnit) {
        this.watchService = watchService;
        this.scheduler = scheduler;
        this.pollDurationMs = pollDurationUnit.toMillis(pollDuration);
        this.pollIntervalMs = pollIntervalUnit.toMillis(pollInterval);
    }

    public void call(final Subscriber<? super WatchEvent<?>> subscriber) {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        subscriber.add((Subscription)worker);
        subscriber.add(OnSubscribeWatchServiceEvents.createSubscriptionToCloseWatchService(this.watchService));
        worker.schedule(new Action0(){

            public void call() {
                if (OnSubscribeWatchServiceEvents.emitEvents(OnSubscribeWatchServiceEvents.this.watchService, subscriber, OnSubscribeWatchServiceEvents.this.pollDurationMs, OnSubscribeWatchServiceEvents.this.pollIntervalMs)) {
                    worker.schedule((Action0)this);
                }
            }
        }, this.pollIntervalMs, TimeUnit.MILLISECONDS);
    }

    private static boolean emitEvents(WatchService watchService, Subscriber<? super WatchEvent<?>> subscriber, long pollDurationMs, long pollIntervalMs) {
        WatchKey key = OnSubscribeWatchServiceEvents.nextKey(watchService, subscriber, pollDurationMs);
        if (key != null) {
            if (subscriber.isUnsubscribed()) {
                return false;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                if (subscriber.isUnsubscribed()) {
                    return false;
                }
                subscriber.onNext(event);
            }
            boolean valid = key.reset();
            if (!valid && !subscriber.isUnsubscribed()) {
                subscriber.onCompleted();
                return false;
            }
            if (!valid) {
                return false;
            }
        }
        return true;
    }

    private static WatchKey nextKey(WatchService watchService, Subscriber<? super WatchEvent<?>> subscriber, long pollDurationMs) {
        try {
            if (pollDurationMs == 0L) {
                return watchService.poll();
            }
            if (pollDurationMs == Long.MAX_VALUE) {
                return watchService.take();
            }
            return watchService.poll(pollDurationMs, TimeUnit.MILLISECONDS);
        }
        catch (ClosedWatchServiceException e) {
            if (!subscriber.isUnsubscribed()) {
                subscriber.onCompleted();
            }
            return null;
        }
        catch (InterruptedException e) {
            try {
                watchService.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final Subscription createSubscriptionToCloseWatchService(final WatchService watchService) {
        return Subscriptions.create((Action0)new Action0(){

            public void call() {
                try {
                    watchService.close();
                }
                catch (ClosedWatchServiceException closedWatchServiceException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

