/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

class ResultSetCache {
    final ResultSet rs;
    final Map<String, Integer> colIndexes;

    ResultSetCache(ResultSet rs) {
        this.rs = rs;
        this.colIndexes = ResultSetCache.collectColIndexes(rs);
    }

    private static Map<String, Integer> collectColIndexes(ResultSet rs) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        try {
            ResultSetMetaData metadata = rs.getMetaData();
            for (int i = 1; i <= metadata.getColumnCount(); ++i) {
                map.put(metadata.getColumnName(i).toUpperCase(), i);
            }
            return map;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
    }
}

