/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.annotations.Column;
import com.github.davidmoten.rx.jdbc.annotations.Index;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

class AutoMapCache {
    final Map<String, Util.Col> methodCols;
    public Class<?> cls;

    AutoMapCache(Class<?> cls) {
        this.cls = cls;
        this.methodCols = AutoMapCache.getMethodCols(cls);
    }

    private static Map<String, Util.Col> getMethodCols(Class<?> cls) {
        HashMap<String, Util.Col> methodCols = new HashMap<String, Util.Col>();
        for (Method method : cls.getMethods()) {
            String name = method.getName();
            Column column = method.getAnnotation(Column.class);
            if (column != null) {
                AutoMapCache.checkHasNoParameters(method);
                String col = column.value();
                if (col.equals("*COLUMN_NOT_SPECIFIED*")) {
                    col = Util.camelCaseToUnderscore(name);
                }
                methodCols.put(name, new Util.NamedCol(col, method.getReturnType()));
                continue;
            }
            Index index = method.getAnnotation(Index.class);
            if (index == null) continue;
            AutoMapCache.checkHasNoParameters(method);
            methodCols.put(name, new Util.IndexedCol(index.value(), method.getReturnType()));
        }
        return methodCols;
    }

    private static void checkHasNoParameters(Method method) {
        if (method.getParameterTypes().length > 0) {
            throw new RuntimeException("mapped interface method cannot have parameters");
        }
    }
}

