/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.RxUtil;
import com.github.davidmoten.rx.jdbc.ResultSetMapper;
import com.github.davidmoten.rx.jdbc.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;

class QuerySelectProducer<T>
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(QuerySelectProducer.class);
    private final ResultSetMapper<? extends T> function;
    private final Subscriber<? super T> subscriber;
    private final Connection con;
    private final PreparedStatement ps;
    private final ResultSet rs;
    private volatile boolean keepGoing = true;
    private final AtomicLong requested = new AtomicLong(0L);

    QuerySelectProducer(ResultSetMapper<? extends T> function, Subscriber<? super T> subscriber, Connection con, PreparedStatement ps, ResultSet rs) {
        this.function = function;
        this.subscriber = subscriber;
        this.con = con;
        this.ps = ps;
        this.rs = rs;
    }

    public void request(long n) {
        if (this.requested.get() == Long.MAX_VALUE) {
            return;
        }
        if (n == Long.MAX_VALUE && this.requested.compareAndSet(0L, Long.MAX_VALUE)) {
            this.requestAll();
        } else if (n > 0L) {
            this.requestSome(n);
        }
    }

    private void requestAll() {
        try {
            while (this.keepGoing) {
                this.processRow(this.subscriber);
            }
            this.closeQuietly();
            this.complete(this.subscriber);
        }
        catch (Throwable e) {
            this.closeAndHandleException(e);
        }
    }

    private void requestSome(long n) {
        long previousCount = RxUtil.getAndAddRequest(this.requested, n);
        if (previousCount == 0L) {
            try {
                block5: {
                    long r;
                    do {
                        long numToEmit = r = this.requested.get();
                        while (this.keepGoing && --numToEmit >= 0L) {
                            this.processRow(this.subscriber);
                        }
                        if (!this.keepGoing) break block5;
                    } while (this.requested.addAndGet(-r) != 0L);
                    return;
                }
                this.closeQuietly();
                this.complete(this.subscriber);
                return;
            }
            catch (Exception e) {
                this.closeAndHandleException(e);
            }
        }
    }

    private void closeAndHandleException(Throwable e) {
        try {
            this.closeQuietly();
        }
        finally {
            this.handleException(e, this.subscriber);
        }
    }

    private void processRow(Subscriber<? super T> subscriber) throws SQLException {
        this.checkSubscription(subscriber);
        if (!this.keepGoing) {
            return;
        }
        if (this.rs.next()) {
            log.trace("onNext");
            subscriber.onNext(this.function.call(this.rs));
        } else {
            this.keepGoing = false;
        }
    }

    private void complete(Subscriber<? super T> subscriber) {
        if (subscriber.isUnsubscribed()) {
            log.debug("unsubscribed");
        } else {
            log.debug("onCompleted");
            subscriber.onCompleted();
        }
    }

    private void handleException(Throwable e, Subscriber<? super T> subscriber) {
        log.debug("onError: {}", (Object)e.getMessage());
        Exceptions.throwOrReport((Throwable)e, subscriber);
    }

    private void closeQuietly() {
        log.debug("closing rs");
        Util.closeQuietly(this.rs);
        log.debug("closing ps");
        Util.closeQuietly(this.ps);
        log.debug("closing con");
        Util.closeQuietlyIfAutoCommit(this.con);
        log.debug("closed");
    }

    private void checkSubscription(Subscriber<? super T> subscriber) {
        if (subscriber.isUnsubscribed()) {
            this.keepGoing = false;
            log.debug("unsubscribing");
        }
    }
}

