/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import com.github.davidmoten.rx.jdbc.ResultSetMapper;
import rx.Observable;
import rx.functions.Func1;

final class QuerySelectTransformer<T, R>
implements Observable.Transformer<R, T> {
    private final QuerySelect.Builder builder;
    private final ResultSetMapper<? extends T> function;
    private final OperatorType operatorType;

    QuerySelectTransformer(QuerySelect.Builder builder, ResultSetMapper<? extends T> function, OperatorType operatorType) {
        this.builder = builder;
        this.function = function;
        this.operatorType = operatorType;
    }

    public Observable<T> call(Observable<R> source) {
        if (this.operatorType == OperatorType.PARAMETER) {
            return this.builder.parameters(source).get(this.function);
        }
        if (this.operatorType == OperatorType.DEPENDENCY) {
            return this.builder.dependsOn(source).get(this.function);
        }
        Observable<R> obs = source;
        return obs.concatMap(new Func1<Observable<Object>, Observable<T>>(){

            public Observable<T> call(Observable<Object> parameters) {
                return QuerySelectTransformer.this.builder.parameters(parameters).get(QuerySelectTransformer.this.function);
            }
        });
    }
}

