/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.ConnectionProvider;
import com.github.davidmoten.rx.jdbc.exceptions.SQLRuntimeException;
import java.sql.Connection;
import java.sql.SQLException;

final class ConnectionProviderAutoCommitting
implements ConnectionProvider {
    private final ConnectionProvider cp;

    ConnectionProviderAutoCommitting(ConnectionProvider cp) {
        this.cp = cp;
    }

    @Override
    public Connection get() {
        Connection con = this.cp.get();
        try {
            con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        return con;
    }

    @Override
    public void close() {
        this.cp.close();
    }
}

