/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.Transformers;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.QuerySelect;
import com.github.davidmoten.rx.jdbc.ResultSetMapper;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func1;

final class QuerySelectOperator<T, R>
implements Observable.Operator<T, R> {
    private final Observable.Operator<T, R> operator;

    QuerySelectOperator(QuerySelect.Builder builder, ResultSetMapper<? extends T> function, OperatorType operatorType) {
        this.operator = Transformers.toOperator(new ApplyQuerySelect(builder, function, operatorType));
    }

    public Subscriber<? super R> call(Subscriber<? super T> subscriber) {
        return (Subscriber)this.operator.call(subscriber);
    }

    private static class ApplyQuerySelect<R, T>
    implements Func1<Observable<R>, Observable<T>> {
        private QuerySelect.Builder builder;
        private ResultSetMapper<? extends T> function;
        private OperatorType operatorType;

        private ApplyQuerySelect(QuerySelect.Builder builder, ResultSetMapper<? extends T> function, OperatorType operatorType) {
            this.builder = builder;
            this.function = function;
            this.operatorType = operatorType;
        }

        public Observable<T> call(Observable<R> observable) {
            if (this.operatorType == OperatorType.PARAMETER) {
                return this.builder.parameters(observable).get(this.function);
            }
            if (this.operatorType == OperatorType.DEPENDENCY) {
                return this.builder.dependsOn(observable).get(this.function);
            }
            Observable<R> obs = observable;
            return obs.concatMap(new Func1<Observable<Object>, Observable<T>>(){

                public Observable<T> call(Observable<Object> parameters) {
                    return ApplyQuerySelect.this.builder.parameters(parameters).get(ApplyQuerySelect.this.function);
                }
            });
        }
    }
}

