/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.jdbc;

import com.github.davidmoten.rx.jdbc.Conditions;
import com.github.davidmoten.rx.jdbc.Database;
import com.github.davidmoten.rx.jdbc.NamedParameters;
import com.github.davidmoten.rx.jdbc.OperatorType;
import com.github.davidmoten.rx.jdbc.Parameter;
import com.github.davidmoten.rx.jdbc.Queries;
import com.github.davidmoten.rx.jdbc.Query;
import com.github.davidmoten.rx.jdbc.QueryBuilder;
import com.github.davidmoten.rx.jdbc.QueryContext;
import com.github.davidmoten.rx.jdbc.QueryUpdateOnSubscribe;
import com.github.davidmoten.rx.jdbc.QueryUpdateOperator;
import com.github.davidmoten.rx.jdbc.QueryUpdateOperatorFromObservable;
import com.github.davidmoten.rx.jdbc.ResultSetMapper;
import com.github.davidmoten.rx.jdbc.Util;
import com.github.davidmoten.rx.jdbc.tuple.Tuple2;
import com.github.davidmoten.rx.jdbc.tuple.Tuple3;
import com.github.davidmoten.rx.jdbc.tuple.Tuple4;
import com.github.davidmoten.rx.jdbc.tuple.Tuple5;
import com.github.davidmoten.rx.jdbc.tuple.Tuple6;
import com.github.davidmoten.rx.jdbc.tuple.Tuple7;
import com.github.davidmoten.rx.jdbc.tuple.TupleN;
import com.github.davidmoten.rx.jdbc.tuple.Tuples;
import java.util.List;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public final class QueryUpdate<T>
implements Query {
    private final NamedParameters.JdbcQuery jdbcQuery;
    private final Observable<Parameter> parameters;
    private final QueryContext context;
    private final Observable<?> depends;
    private final ResultSetMapper<? extends T> returnGeneratedKeysFunction;

    private QueryUpdate(String sql, Observable<Parameter> parameters, Observable<?> depends, QueryContext context, ResultSetMapper<? extends T> returnGeneratedKeysFunction) {
        Conditions.checkNotNull(sql);
        Conditions.checkNotNull(parameters);
        Conditions.checkNotNull(depends);
        Conditions.checkNotNull(context);
        this.jdbcQuery = NamedParameters.parse(sql);
        this.parameters = parameters;
        this.depends = depends;
        this.context = context;
        this.returnGeneratedKeysFunction = returnGeneratedKeysFunction;
    }

    @Override
    public String sql() {
        return this.jdbcQuery.sql();
    }

    @Override
    public Observable<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public QueryContext context() {
        return this.context;
    }

    public String toString() {
        return "QueryUpdate [sql=" + this.sql() + "]";
    }

    @Override
    public Observable<?> depends() {
        return this.depends;
    }

    @Override
    public List<String> names() {
        return this.jdbcQuery.names();
    }

    public Observable<Integer> count() {
        return QueryUpdate.get(this);
    }

    public ResultSetMapper<? extends T> returnGeneratedKeysFunction() {
        return this.returnGeneratedKeysFunction;
    }

    boolean returnGeneratedKeys() {
        return this.returnGeneratedKeysFunction != null;
    }

    static <T> Observable<T> get(QueryUpdate<T> queryUpdate) {
        return Queries.bufferedParameters(queryUpdate).concatMap(super.executeOnce());
    }

    private Func1<List<Parameter>, Observable<T>> executeOnce() {
        return new Func1<List<Parameter>, Observable<T>>(){

            public Observable<T> call(List<Parameter> params) {
                if (QueryUpdate.this.jdbcQuery.sql().equals("begin")) {
                    QueryUpdate.this.context.beginTransactionSubscribe();
                }
                Observable result = QueryUpdate.this.executeOnce(params).subscribeOn(QueryUpdate.this.context.scheduler());
                if (QueryUpdate.this.jdbcQuery.sql().equals("commit") || QueryUpdate.this.jdbcQuery.sql().equals("rollback")) {
                    QueryUpdate.this.context.endTransactionSubscribe();
                }
                return result;
            }
        };
    }

    private Observable<T> executeOnce(List<Parameter> parameters) {
        return QueryUpdateOnSubscribe.execute(this, parameters);
    }

    public static class ReturnGeneratedKeysBuilder {
        private final QueryBuilder builder;

        public ReturnGeneratedKeysBuilder(QueryBuilder builder) {
            this.builder = builder;
        }

        public <T> Observable<T> get(ResultSetMapper<? extends T> function) {
            return QueryUpdate.get(new QueryUpdate(this.builder.sql(), this.builder.parameters(), this.builder.depends(), this.builder.context(), function));
        }

        public <T> Observable<T> autoMap(Class<T> cls) {
            Util.setSqlFromQueryAnnotation(cls, this.builder);
            return this.get(Util.autoMap(cls));
        }

        public <T> Observable<T> getAs(Class<T> cls) {
            return this.get(Tuples.single(cls));
        }

        public <T> Observable<TupleN<T>> getTupleN(Class<T> cls) {
            return this.get(Tuples.tupleN(cls));
        }

        public Observable<TupleN<Object>> getTupleN() {
            return this.get(Tuples.tupleN(Object.class));
        }

        public <T1, T2> Observable<Tuple2<T1, T2>> getAs(Class<T1> cls1, Class<T2> cls2) {
            return this.get(Tuples.tuple(cls1, cls2));
        }

        public <T1, T2, T3> Observable<Tuple3<T1, T2, T3>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            return this.get(Tuples.tuple(cls1, cls2, cls3));
        }

        public <T1, T2, T3, T4> Observable<Tuple4<T1, T2, T3, T4>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4));
        }

        public <T1, T2, T3, T4, T5> Observable<Tuple5<T1, T2, T3, T4, T5>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5));
        }

        public <T1, T2, T3, T4, T5, T6> Observable<Tuple6<T1, T2, T3, T4, T5, T6>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> Observable<Tuple7<T1, T2, T3, T4, T5, T6, T7>> getAs(Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4, Class<T5> cls5, Class<T6> cls6, Class<T7> cls7) {
            return this.get(Tuples.tuple(cls1, cls2, cls3, cls4, cls5, cls6, cls7));
        }

        public Observable<Integer> count() {
            return this.get(Util.toOne()).count();
        }
    }

    public static final class Builder {
        private final QueryBuilder builder;

        public Builder(String sql, Database db) {
            this.builder = new QueryBuilder(sql, db);
        }

        public <T> Builder parameters(Observable<T> parameters) {
            this.builder.parameters(parameters);
            return this;
        }

        public Builder parameters(Object ... objects) {
            this.builder.parameters(objects);
            return this;
        }

        public Builder parameter(Object value) {
            this.builder.parameter(value);
            return this;
        }

        public Builder parameter(String name, Object value) {
            this.builder.parameter(name, value);
            return this;
        }

        public Builder parameterClob(String value) {
            this.builder.parameter(Database.toSentinelIfNull(value));
            return this;
        }

        public Builder parameterBlob(byte[] bytes) {
            this.builder.parameter(Database.toSentinelIfNull(bytes));
            return this;
        }

        public Builder dependsOn(Observable<?> dependency) {
            this.builder.dependsOn(dependency);
            return this;
        }

        public Builder dependsOnLastTransaction() {
            this.builder.dependsOnLastTransaction();
            return this;
        }

        public ReturnGeneratedKeysBuilder returnGeneratedKeys() {
            return new ReturnGeneratedKeysBuilder(this.builder);
        }

        public Observable<Integer> count() {
            return new QueryUpdate(this.builder.sql(), this.builder.parameters(), this.builder.depends(), this.builder.context(), null).count();
        }

        public int execute() {
            return (Integer)this.count().reduce((Object)0, TotalHolder.TOTAL).toBlocking().single();
        }

        public Observable.Operator<Integer, Object> parameterOperator() {
            return new QueryUpdateOperator<Object>(this, OperatorType.PARAMETER);
        }

        public Observable.Operator<Integer, Object> dependsOnOperator() {
            return new QueryUpdateOperator<Object>(this, OperatorType.DEPENDENCY);
        }

        public Observable.Operator<Observable<Integer>, Observable<Object>> parameterListOperator() {
            return new QueryUpdateOperatorFromObservable<Object>(this);
        }

        public Builder clearParameters() {
            this.builder.clearParameters();
            return this;
        }

        private static final class TotalHolder {
            static final Func2<Integer, Integer, Integer> TOTAL = new Func2<Integer, Integer, Integer>(){

                public Integer call(Integer a, Integer b) {
                    return a + b;
                }
            };

            private TotalHolder() {
            }
        }
    }
}

