/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.flowable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.github.davidmoten.rx2.Consumers;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.Callable;

public final class Serialized {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private Serialized() {
    }

    public static <T extends Serializable> Flowable<T> read(final ObjectInputStream ois) {
        return Flowable.generate((Consumer)new Consumer<Emitter<T>>(){

            public void accept(Emitter<T> emitter) throws Exception {
                try {
                    Serializable t = (Serializable)ois.readObject();
                    emitter.onNext((Object)t);
                }
                catch (EOFException e) {
                    emitter.onComplete();
                }
                catch (ClassNotFoundException e) {
                    emitter.onError((Throwable)e);
                }
                catch (IOException e) {
                    emitter.onError((Throwable)e);
                }
            }
        });
    }

    public static <T extends Serializable> Flowable<T> read(final File file, final int bufferSize) {
        Callable<ObjectInputStream> resourceFactory = new Callable<ObjectInputStream>(){

            @Override
            public ObjectInputStream call() throws IOException {
                return new ObjectInputStream(new BufferedInputStream(new FileInputStream(file), bufferSize));
            }
        };
        Function<ObjectInputStream, Flowable<Serializable>> flowableFactory = ObjectInputStreamFlowableFactoryHolder.INSTANCE;
        Consumer disposeAction = Consumers.close();
        return Flowable.using((Callable)resourceFactory, flowableFactory, disposeAction, (boolean)true);
    }

    public static <T extends Serializable> Flowable<T> read(File file) {
        return Serialized.read(file, 8192);
    }

    public static <T extends Serializable> Flowable<T> write(Flowable<T> source, final ObjectOutputStream oos) {
        return source.doOnNext(new Consumer<T>(){

            public void accept(T t) throws IOException {
                oos.writeObject(t);
            }
        });
    }

    public static <T extends Serializable> Flowable<T> write(final Flowable<T> source, final File file, final boolean append, final int bufferSize) {
        Callable<ObjectOutputStream> resourceFactory = new Callable<ObjectOutputStream>(){

            @Override
            public ObjectOutputStream call() throws IOException {
                return new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file, append), bufferSize));
            }
        };
        Function flowableFactory = new Function<ObjectOutputStream, Flowable<T>>(){

            public Flowable<T> apply(ObjectOutputStream oos) {
                return Serialized.write(source, oos);
            }
        };
        Consumer disposeAction = Consumers.close();
        return Flowable.using((Callable)resourceFactory, (Function)flowableFactory, disposeAction, (boolean)true);
    }

    public static <T extends Serializable> Flowable<T> write(Flowable<T> source, File file, boolean append) {
        return Serialized.write(source, file, append, 8192);
    }

    public static <T extends Serializable> Flowable<T> write(Flowable<T> source, File file) {
        return Serialized.write(source, file, false, 8192);
    }

    public static KryoBuilder kryo() {
        return Serialized.kryo(new Kryo());
    }

    public static KryoBuilder kryo(Kryo kryo) {
        return new KryoBuilder(kryo);
    }

    public static class KryoBuilder {
        private static final int DEFAULT_BUFFER_SIZE = 4096;
        private final Kryo kryo;

        private KryoBuilder(Kryo kryo) {
            this.kryo = kryo;
        }

        public <T> Flowable<T> write(Flowable<T> source, File file) {
            return this.write(source, file, false, 4096);
        }

        public <T> Flowable<T> write(Flowable<T> source, File file, boolean append) {
            return this.write(source, file, append, 4096);
        }

        public <T> Flowable<T> write(final Flowable<T> source, final File file, final boolean append, final int bufferSize) {
            Callable<Output> resourceFactory = new Callable<Output>(){

                @Override
                public Output call() throws FileNotFoundException {
                    return new Output((OutputStream)new FileOutputStream(file, append), bufferSize);
                }
            };
            Function flowableFactory = new Function<Output, Flowable<T>>(){

                public Flowable<T> apply(final Output output) {
                    return source.doOnNext(new Consumer<T>(){

                        public void accept(T t) {
                            KryoBuilder.this.kryo.writeObject(output, t);
                        }
                    });
                }
            };
            Consumer disposeAction = Consumers.close();
            return Flowable.using((Callable)resourceFactory, (Function)flowableFactory, disposeAction, (boolean)true);
        }

        public <T> Flowable<T> read(Class<T> cls, File file) {
            return this.read(cls, file, 4096);
        }

        public <T> Flowable<T> read(final Class<T> cls, final File file, final int bufferSize) {
            Callable<Input> resourceFactory = new Callable<Input>(){

                @Override
                public Input call() throws FileNotFoundException {
                    return new Input((InputStream)new FileInputStream(file), bufferSize);
                }
            };
            Function flowableFactory = new Function<Input, Flowable<T>>(){

                public Flowable<T> apply(Input input) {
                    return KryoBuilder.this.read(cls, input);
                }
            };
            Consumer disposeAction = Consumers.close();
            return Flowable.using((Callable)resourceFactory, (Function)flowableFactory, disposeAction, (boolean)true);
        }

        public <T> Flowable<T> read(final Class<T> cls, final Input input) {
            return Flowable.generate((Consumer)new Consumer<Emitter<T>>(){

                public void accept(Emitter<T> emitter) throws Exception {
                    if (input.eof()) {
                        emitter.onComplete();
                    } else {
                        Object t = KryoBuilder.this.kryo.readObject(input, cls);
                        emitter.onNext(t);
                    }
                }
            });
        }
    }

    private static final class ObjectInputStreamFlowableFactoryHolder {
        static final Function<ObjectInputStream, Flowable<Serializable>> INSTANCE = new Function<ObjectInputStream, Flowable<Serializable>>(){

            public Flowable<Serializable> apply(ObjectInputStream is) throws Exception {
                return Serialized.read(is);
            }
        };

        private ObjectInputStreamFlowableFactoryHolder() {
        }
    }
}

