/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SchedulerWithId
extends Scheduler {
    private final Scheduler scheduler;
    private final String id;
    private static final Pattern pattern = Pattern.compile("\\bschedId=\\[[^\\]]+\\]+\\b");

    public SchedulerWithId(Scheduler scheduler, String id) {
        this.scheduler = scheduler;
        this.id = "[" + id + "]";
    }

    public Scheduler.Worker createWorker() {
        final Scheduler.Worker worker = this.scheduler.createWorker();
        Scheduler.Worker w = new Scheduler.Worker(){

            public Disposable schedule(final Runnable action, long delayTime, TimeUnit unit) {
                Runnable a = new Runnable(){

                    @Override
                    public void run() {
                        String name = null;
                        try {
                            name = SchedulerWithId.this.setThreadName();
                            action.run();
                        }
                        finally {
                            if (name != null) {
                                Thread.currentThread().setName(name);
                            }
                        }
                    }
                };
                return worker.schedule(a, delayTime, unit);
            }

            public void dispose() {
                worker.dispose();
            }

            public boolean isDisposed() {
                return worker.isDisposed();
            }
        };
        return w;
    }

    private String setThreadName() {
        String name = Thread.currentThread().getName();
        String newName = SchedulerWithId.updateNameWithId(name, this.id);
        Thread.currentThread().setName(newName);
        return name;
    }

    private static String updateNameWithId(String name, String id) {
        Matcher matcher;
        String newName = name == null ? id : ((matcher = pattern.matcher(name)).find() ? name.replace(matcher.group(), "schedId=" + id) : name + "|schedId=" + id);
        return newName;
    }
}

