/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.LongConsumer;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;

public final class FlowableFetchPagesByRequest {
    private FlowableFetchPagesByRequest() {
    }

    public static <T> Flowable<T> create(final BiFunction<? super Long, ? super Long, ? extends Flowable<T>> fetch, final long start, final int maxConcurrency) {
        return Flowable.defer((Callable)new Callable<Flowable<T>>(){

            @Override
            public Flowable<T> call() throws Exception {
                final ReplaySubject subject = ReplaySubject.create();
                final AtomicLong position = new AtomicLong(start);
                LongConsumer request = new LongConsumer(){

                    public void accept(long n) throws Exception {
                        long pos = position.getAndAdd(n);
                        if (SubscriptionHelper.validate((long)n)) {
                            Flowable flowable;
                            try {
                                flowable = (Flowable)fetch.apply((Object)pos, (Object)n);
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal((Throwable)e);
                                subject.onError(e);
                                return;
                            }
                            Count count = new Count((Subject<?>)subject, n);
                            flowable = flowable.doOnNext((Consumer)count).doOnComplete((Action)count);
                            subject.onNext((Object)flowable);
                        }
                    }
                };
                return Flowable.concatEager((Publisher)subject.serialize().toFlowable(BackpressureStrategy.BUFFER), (int)maxConcurrency, (int)128).doOnRequest(request);
            }
        });
    }

    private static final class Count
    implements Consumer<Object>,
    Action {
        private final Subject<?> subject;
        private final long n;
        private long count;

        Count(Subject<?> subject, long n) {
            this.subject = subject;
            this.n = n;
        }

        public void accept(Object t) throws Exception {
            ++this.count;
        }

        public void run() throws Exception {
            if (this.count < this.n) {
                this.subject.onComplete();
            }
        }
    }
}

