/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRepeatingTransform<T>
extends Flowable<T> {
    private final Flowable<T> source;
    private final Function<? super Flowable<T>, ? extends Flowable<T>> transform;
    private final int maxChained;
    private final long maxIterations;
    private final Function<Observable<T>, ? extends Observable<?>> tester;

    public FlowableRepeatingTransform(Flowable<T> source, Function<? super Flowable<T>, ? extends Flowable<T>> transform, int maxChained, long maxIterations, Function<Observable<T>, Observable<?>> tester) {
        Preconditions.checkArgument((maxChained > 0 ? 1 : 0) != 0, (String)"maxChained must be > 0");
        Preconditions.checkArgument((maxIterations > 0L ? 1 : 0) != 0, (String)"maxIterations must be > 0");
        Preconditions.checkNotNull(transform, (String)"transform must not be null");
        Preconditions.checkNotNull(tester, (String)"tester must not be null");
        this.source = source;
        this.transform = transform;
        this.maxChained = maxChained;
        this.maxIterations = maxIterations;
        this.tester = tester;
    }

    protected void subscribeActual(Subscriber<? super T> child) {
        Flowable f;
        try {
            f = (Flowable)this.transform.apply(this.source);
        }
        catch (Exception e) {
            Exceptions.throwIfFatal((Throwable)e);
            child.onSubscribe((Subscription)SubscriptionHelper.CANCELLED);
            child.onError((Throwable)e);
            return;
        }
        AtomicReference chainRef = new AtomicReference();
        DestinationSerializedSubject<? super T> destination = new DestinationSerializedSubject<T>(child, chainRef);
        Chain<? super T> chain = new Chain<T>(this.transform, destination, this.maxIterations, this.maxChained, this.tester);
        chainRef.set(chain);
        destination.subscribe(child);
        ChainedReplaySubject<? super T> sub = ChainedReplaySubject.create(destination, chain, this.tester);
        chain.initialize(sub);
        f.onTerminateDetach().subscribe(sub);
    }

    static void debug(String message) {
    }

    static void log(String message) {
    }

    private static final class MultiSubscription
    implements Subscription {
        private final Subscription primary;
        private final Subscription secondary;

        MultiSubscription(Subscription primary, Subscription secondary) {
            this.primary = primary;
            this.secondary = secondary;
        }

        public void request(long n) {
            this.primary.request(n);
        }

        public void cancel() {
            this.primary.cancel();
            this.secondary.cancel();
        }
    }

    private static final class ChainedReplaySubject<T>
    extends Flowable<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private final DestinationSerializedSubject<T> destination;
        private final Chain<T> chain;
        private final SimplePlainQueue<T> queue = new SpscLinkedArrayQueue(16);
        private final AtomicLong requested = new AtomicLong();
        private final AtomicReference<Requests<T>> requests = new AtomicReference(new Requests(null, 0L, 0L, null));
        private final AtomicInteger wip = new AtomicInteger();
        private final Tester<T> tester;
        private volatile boolean done;
        private Throwable error;
        private volatile boolean cancelled;
        private final Function<Observable<T>, ? extends Observable<?>> test;

        static <T> ChainedReplaySubject<T> create(DestinationSerializedSubject<T> destination, Chain<T> chain, Function<Observable<T>, ? extends Observable<?>> test) {
            ChainedReplaySubject<T> c = new ChainedReplaySubject<T>(destination, chain, test);
            super.init();
            return c;
        }

        private ChainedReplaySubject(DestinationSerializedSubject<T> destination, Chain<T> chain, Function<Observable<T>, ? extends Observable<?>> test) {
            this.destination = destination;
            this.chain = chain;
            this.test = test;
            this.tester = new Tester();
        }

        private void init() {
            Observable o;
            try {
                o = (Observable)this.test.apply(this.tester);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            o.subscribe(new TesterObserver<T>(this.chain, this));
        }

        DestinationSerializedSubject<T> destination() {
            return this.destination;
        }

        public void onSubscribe(Subscription parent) {
            block2: {
                Requests<T> r;
                while (true) {
                    Requests r2;
                    r = this.requests.get();
                    if (r.deferred == 0L) {
                        r2 = new Requests(parent, r.unreconciled + 1L, 0L, r.child);
                        if (!this.requests.compareAndSet(r, r2)) continue;
                        parent.request(1L);
                        break block2;
                    }
                    r2 = new Requests(parent, r.unreconciled, 0L, r.child);
                    if (this.requests.compareAndSet(r, r2)) break;
                }
                parent.request(r.deferred);
            }
            this.drain();
        }

        protected void subscribeActual(Subscriber<? super T> child) {
            Requests<? super T> r2;
            Requests<T> r;
            FlowableRepeatingTransform.debug((Object)((Object)this) + " subscribed with " + child);
            while (!this.requests.compareAndSet(r = this.requests.get(), r2 = new Requests<T>(r.parent, r.unreconciled, r.deferred, child))) {
            }
            child.onSubscribe((Subscription)this);
            this.drain();
        }

        public void request(long n) {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " request " + n);
            if (SubscriptionHelper.validate((long)n)) {
                block5: {
                    long x;
                    Requests<T> r;
                    BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                    while (true) {
                        Requests r2;
                        r = this.requests.get();
                        if (r.parent == null) {
                            long d = r.deferred + n;
                            if (d < 0L) {
                                d = Long.MAX_VALUE;
                            }
                            if (!this.requests.compareAndSet(r, r2 = new Requests(r.parent, r.unreconciled, d, r.child))) continue;
                            break block5;
                        }
                        x = n + r.deferred - r.unreconciled;
                        long u = Math.max(0L, -x);
                        r2 = new Requests(r.parent, u, 0L, r.child);
                        if (this.requests.compareAndSet(r, r2)) break;
                    }
                    if (x > 0L) {
                        r.parent.request(x);
                    }
                }
                this.drain();
            }
        }

        public void onNext(T t) {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " arrived " + t);
            if (this.done) {
                return;
            }
            this.queue.offer(t);
            this.tester.onNext(t);
            while (true) {
                Requests r2;
                Requests<T> r = this.requests.get();
                if (r.child == null) {
                    r2 = new Requests(r.parent, r.unreconciled + 1L, r.deferred, r.child);
                    if (!this.requests.compareAndSet(r, r2)) continue;
                    r.parent.request(1L);
                    break;
                }
                r2 = new Requests(r.parent, r.unreconciled, 0L, r.child);
                if (this.requests.compareAndSet(r, r2)) break;
            }
            this.drain();
        }

        public void onComplete() {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " complete");
            if (this.done) {
                return;
            }
            this.done = true;
            this.cancelParent();
            FlowableRepeatingTransform.debug((Object)((Object)this) + " emits complete to tester");
            this.tester.onComplete();
            this.drain();
        }

        public void onError(Throwable t) {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " error " + t);
            if (this.done) {
                RxJavaPlugins.onError((Throwable)t);
                return;
            }
            this.error = t;
            this.done = true;
            this.tester.onError(t);
            this.drain();
        }

        private void drain() {
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                do {
                    long e;
                    long r = this.requested.get();
                    boolean d = this.done;
                    for (e = 0L; e != r; ++e) {
                        if (this.cancelled) {
                            this.queue.clear();
                            return;
                        }
                        Subscriber child = this.requests.get().child;
                        if (child == null) break;
                        Throwable err = this.error;
                        if (err != null) {
                            this.queue.clear();
                            this.error = null;
                            this.cancel();
                            this.chain.onError(child, err);
                            return;
                        }
                        Object t = this.queue.poll();
                        if (t == null) {
                            if (!d) break;
                            this.cancel();
                            this.chain.onCompleted(child);
                            return;
                        }
                        FlowableRepeatingTransform.debug((Object)((Object)this) + " emitting " + t + " to " + this.requests.get().child + ":" + this.requests.get().child.getClass().getSimpleName());
                        this.chain.onNext(child, t);
                        d = this.done;
                    }
                    if (d && this.queue.isEmpty() && this.terminate()) {
                        return;
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    r = this.requested.addAndGet(-e);
                } while ((missed = this.wip.addAndGet(-missed)) != 0);
                return;
            }
        }

        private boolean terminate() {
            Subscriber child = this.requests.get().child;
            if (child != null) {
                Throwable err = this.error;
                if (err != null) {
                    this.queue.clear();
                    this.error = null;
                    this.cancel();
                    this.chain.onError(child, err);
                    return true;
                }
                this.cancel();
                this.chain.onCompleted(child);
                return true;
            }
            return false;
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelParentTryToAddSubscriberToChain();
            }
        }

        private void cancelParentTryToAddSubscriberToChain() {
            this.cancelParent();
            this.chain.completeOrCancel(this);
        }

        private void cancelParent() {
            Subscription par = this.requests.get().parent;
            if (par != null) {
                par.cancel();
            }
        }

        private static final class Requests<T> {
            final Subscription parent;
            final long unreconciled;
            final long deferred;
            final Subscriber<? super T> child;

            Requests(Subscription parent, long unreconciled, long deferred, Subscriber<? super T> child) {
                this.parent = parent;
                this.unreconciled = unreconciled;
                this.deferred = deferred;
                this.child = child;
            }
        }
    }

    private static final class TesterObserver<T>
    implements Observer<Object> {
        private final Chain<T> chain;
        private final ChainedReplaySubject<T> subject;

        TesterObserver(Chain<T> chain, ChainedReplaySubject<T> subject) {
            this.chain = chain;
            this.subject = subject;
        }

        public void onSubscribe(Disposable d) {
        }

        public void onNext(Object t) {
            FlowableRepeatingTransform.debug(this.subject + " TestObserver emits add " + t);
            this.chain.tryAddSubscriber(this.subject);
        }

        public void onError(Throwable e) {
            this.chain.cancel();
            this.subject.destination().onError(e);
        }

        public void onComplete() {
            FlowableRepeatingTransform.debug(this.subject + " TestObserver emits done");
            this.chain.done(this.subject);
        }
    }

    private static final class Tester<T>
    extends Observable<T>
    implements Observer<T> {
        private Observer<? super T> observer;

        private Tester() {
        }

        protected void subscribeActual(Observer<? super T> observer) {
            observer.onSubscribe(Disposables.empty());
            this.observer = observer;
        }

        public void onSubscribe(Disposable d) {
            throw new RuntimeException("unexpected");
        }

        public void onNext(T t) {
            this.observer.onNext(t);
        }

        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        public void onComplete() {
            this.observer.onComplete();
        }
    }

    private static class DestinationSerializedSubject<T>
    extends Flowable<T>
    implements FlowableSubscriber<T>,
    Subscription {
        private final Subscriber<? super T> child;
        private final AtomicReference<Chain<T>> chain;
        private final AtomicInteger wip = new AtomicInteger();
        private final AtomicReference<Subscription> parent = new AtomicReference();
        private final AtomicLong requested = new AtomicLong();
        private final SimplePlainQueue<T> queue = new SpscLinkedArrayQueue(16);
        private final AtomicLong deferredRequests = new AtomicLong();
        private Throwable error;
        private volatile boolean done;
        private volatile boolean cancelled;

        DestinationSerializedSubject(Subscriber<? super T> child, AtomicReference<Chain<T>> chain) {
            this.child = child;
            this.chain = chain;
        }

        protected void subscribeActual(Subscriber<? super T> child) {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " subscribed to by " + child);
            child.onSubscribe((Subscription)new MultiSubscription(this, this.chain.get()));
        }

        public void onSubscribe(Subscription pr) {
            this.parent.set(pr);
            long r = this.deferredRequests.getAndSet(-1L);
            if (r > 0L) {
                FlowableRepeatingTransform.debug((Object)((Object)this) + " requesting of parent " + r);
                pr.request(r);
            }
            this.drain();
        }

        public void request(long n) {
            FlowableRepeatingTransform.debug((Object)((Object)this) + " request " + n);
            if (SubscriptionHelper.validate((long)n)) {
                long d2;
                long d;
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
                do {
                    Subscription p = this.parent.get();
                    d = this.deferredRequests.get();
                    if (d == -1L) {
                        FlowableRepeatingTransform.debug((Object)((Object)this) + " requesting from parent " + n);
                        p.request(n);
                        break;
                    }
                    d2 = d + n;
                    if (d2 >= 0L) continue;
                    d2 = Long.MAX_VALUE;
                } while (!this.deferredRequests.compareAndSet(d, d2));
                this.drain();
            }
        }

        public void cancel() {
            this.cancelled = true;
            SubscriptionHelper.cancel(this.parent);
            this.chain.get().cancel();
        }

        public void onNext(T t) {
            this.queue.offer(t);
            this.drain();
        }

        public void onError(Throwable e) {
            this.error = e;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            FlowableRepeatingTransform.debug("final complete");
            this.done = true;
            this.drain();
        }

        private void drain() {
            if (this.wip.getAndIncrement() == 0) {
                int missed = 1;
                do {
                    long e;
                    long r = this.requested.get();
                    boolean d = this.done;
                    for (e = 0L; e != r; ++e) {
                        if (this.cancelled) {
                            this.queue.clear();
                            return;
                        }
                        if (d && this.terminate()) {
                            return;
                        }
                        Object t = this.queue.poll();
                        if (t == null) {
                            if (!d) break;
                            this.cancel();
                            this.child.onComplete();
                            return;
                        }
                        this.child.onNext(t);
                        d = this.done;
                    }
                    if (d && this.terminate()) {
                        return;
                    }
                    if (e == 0L || r == Long.MAX_VALUE) continue;
                    r = this.requested.addAndGet(-e);
                } while ((missed = this.wip.addAndGet(-missed)) != 0);
                return;
            }
        }

        private boolean terminate() {
            Throwable err = this.error;
            if (err != null) {
                this.queue.clear();
                this.error = null;
                this.cancel();
                this.child.onError(err);
                return true;
            }
            if (this.queue.isEmpty()) {
                this.cancel();
                this.child.onComplete();
                return true;
            }
            return false;
        }
    }

    private static final class Chain<T>
    extends AtomicInteger
    implements Subscription {
        private final Function<? super Flowable<T>, ? extends Flowable<T>> transform;
        private final SimplePlainQueue<Event<T>> queue;
        private final DestinationSerializedSubject<T> destination;
        private final long maxIterations;
        private final int maxChained;
        private final Function<Observable<T>, ? extends Observable<?>> test;
        private int iteration = 1;
        private int length;
        private ChainedReplaySubject<T> finalSubscriber;
        private boolean destinationAttached;
        private volatile boolean cancelled;

        Chain(Function<? super Flowable<T>, ? extends Flowable<T>> transform, DestinationSerializedSubject<T> destination, long maxIterations, int maxChained, Function<Observable<T>, ? extends Observable<?>> test) {
            this.transform = transform;
            this.destination = destination;
            this.maxIterations = maxIterations;
            this.maxChained = maxChained;
            this.test = test;
            this.queue = new SpscLinkedArrayQueue(16);
        }

        void initialize(ChainedReplaySubject<T> subject) {
            this.finalSubscriber = subject;
            if (this.maxIterations == 1L) {
                this.finalSubscriber.subscribe(this.destination);
                this.destinationAttached = true;
            }
        }

        void tryAddSubscriber(ChainedReplaySubject<T> subject) {
            this.queue.offer(new Event<Object>(EventType.TESTER_ADD, subject, null, null, null));
            this.drain();
        }

        void done(ChainedReplaySubject<T> subject) {
            this.queue.offer(new Event<Object>(EventType.TESTER_DONE, subject, null, null, null));
            this.drain();
        }

        void completeOrCancel(ChainedReplaySubject<T> subject) {
            this.queue.offer(new Event<Object>(EventType.TESTER_COMPLETE_OR_CANCEL, subject, null, null, null));
            this.drain();
        }

        public void onError(Subscriber<? super T> child, Throwable err) {
            this.queue.offer(new Event<Object>(EventType.ERROR, null, child, null, err));
            this.drain();
        }

        public void onCompleted(Subscriber<? super T> child) {
            this.queue.offer(new Event<Object>(EventType.COMPLETE, null, child, null, null));
            this.drain();
        }

        public void onNext(Subscriber<? super T> child, T t) {
            this.queue.offer(new Event<T>(EventType.NEXT, null, child, t, null));
            this.drain();
        }

        void drain() {
            block8: {
                if (this.getAndIncrement() != 0) break block8;
                if (this.cancelled) {
                    this.finalSubscriber.cancel();
                    this.queue.clear();
                    return;
                }
                int missed = 1;
                while (true) {
                    Event v;
                    if ((v = (Event)this.queue.poll()) != null) {
                        if (v.eventType == EventType.TESTER_ADD) {
                            this.handleAdd(v);
                            continue;
                        }
                        if (v.eventType == EventType.TESTER_DONE) {
                            this.handleDone();
                            continue;
                        }
                        if (v.eventType == EventType.NEXT) {
                            v.subscriber.onNext(v.t);
                            continue;
                        }
                        if (v.eventType == EventType.COMPLETE) {
                            v.subscriber.onComplete();
                            continue;
                        }
                        if (v.eventType == EventType.ERROR) {
                            v.subscriber.onError(v.error);
                            continue;
                        }
                        this.handleCompleteOrCancel(v);
                        continue;
                    }
                    if ((missed = this.addAndGet(-missed)) == 0) break;
                }
            }
        }

        private void handleAdd(Event<T> v) {
            FlowableRepeatingTransform.debug("ADD " + v.subject);
            if (!this.destinationAttached && v.subject == this.finalSubscriber && this.length < this.maxChained && !this.destinationAttached && (long)this.iteration <= this.maxIterations - 1L) {
                ChainedReplaySubject<T> sub = ChainedReplaySubject.create(this.destination, this, this.test);
                if ((long)this.iteration == this.maxIterations - 1L) {
                    sub.subscribe(this.destination);
                    FlowableRepeatingTransform.debug(sub + "subscribed to by destination");
                    this.destinationAttached = true;
                }
                this.addToChain((Subscriber<T>)sub);
                this.finalSubscriber = sub;
                ++this.iteration;
                ++this.length;
            }
        }

        private void handleDone() {
            FlowableRepeatingTransform.debug("DONE");
            if (!this.destinationAttached) {
                this.destinationAttached = true;
                this.finalSubscriber.subscribe(this.destination);
            }
        }

        private void handleCompleteOrCancel(Event<T> v) {
            FlowableRepeatingTransform.debug("COMPLETE/CANCEL " + v.subject);
            if (this.destinationAttached) {
                return;
            }
            if (v.subject != this.finalSubscriber) {
                if ((long)this.iteration < this.maxIterations - 1L) {
                    ChainedReplaySubject<T> sub = ChainedReplaySubject.create(this.destination, this, this.test);
                    this.addToChain((Subscriber<T>)sub);
                    this.finalSubscriber = sub;
                    ++this.iteration;
                } else if ((long)this.iteration == this.maxIterations - 1L) {
                    ChainedReplaySubject<T> sub = ChainedReplaySubject.create(this.destination, this, this.test);
                    this.destinationAttached = true;
                    sub.subscribe(this.destination);
                    this.addToChain((Subscriber<T>)sub);
                    FlowableRepeatingTransform.debug(sub + "subscribed to by destination");
                    this.finalSubscriber = sub;
                    ++this.iteration;
                } else {
                    --this.length;
                }
            }
        }

        private void addToChain(Subscriber<T> sub) {
            Flowable f;
            try {
                f = (Flowable)this.transform.apply(this.finalSubscriber);
            }
            catch (Exception e) {
                Exceptions.throwIfFatal((Throwable)e);
                this.cancelWholeChain();
                this.destination.onError(e);
                return;
            }
            FlowableRepeatingTransform.log("adding subscriber to " + this.finalSubscriber);
            f.onTerminateDetach().subscribe(sub);
            FlowableRepeatingTransform.debug(this.finalSubscriber + " subscribed to by " + sub);
        }

        private void cancelWholeChain() {
            this.cancelled = true;
            this.drain();
        }

        public void request(long n) {
        }

        public void cancel() {
            this.cancelled = true;
            this.cancelWholeChain();
        }
    }

    private static final class Event<T> {
        final EventType eventType;
        final ChainedReplaySubject<T> subject;
        final Subscriber<? super T> subscriber;
        final T t;
        final Throwable error;

        Event(EventType eventType, ChainedReplaySubject<T> subject, Subscriber<? super T> subscriber, T t, Throwable error) {
            this.eventType = eventType;
            this.subject = subject;
            this.subscriber = subscriber;
            this.t = t;
            this.error = error;
        }
    }

    private static enum EventType {
        TESTER_ADD,
        TESTER_DONE,
        TESTER_COMPLETE_OR_CANCEL,
        NEXT,
        ERROR,
        COMPLETE;

    }
}

