/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;

public final class FlowableServerSocket {
    private FlowableServerSocket() {
    }

    public static Flowable<Flowable<byte[]>> create(Callable<? extends ServerSocket> serverSocketFactory, int timeoutMs, int bufferSize, Action preAcceptAction, int acceptTimeoutMs, Predicate<? super Socket> acceptSocket) {
        Function<ServerSocket, Flowable<Flowable<byte[]>>> FlowableFactory = FlowableServerSocket.createFlowableFactory(timeoutMs, bufferSize, preAcceptAction, acceptSocket);
        return Flowable.using(FlowableServerSocket.createServerSocketFactory(serverSocketFactory, acceptTimeoutMs), FlowableFactory, (Consumer)new Consumer<ServerSocket>(){

            public void accept(ServerSocket ss) throws Exception {
                ss.close();
            }
        }, (boolean)true);
    }

    private static Callable<ServerSocket> createServerSocketFactory(final Callable<? extends ServerSocket> serverSocketFactory, final int acceptTimeoutMs) {
        return new Callable<ServerSocket>(){

            @Override
            public ServerSocket call() throws Exception {
                return FlowableServerSocket.createServerSocket(serverSocketFactory, acceptTimeoutMs);
            }
        };
    }

    private static ServerSocket createServerSocket(Callable<? extends ServerSocket> serverSocketCreator, long timeoutMs) throws Exception {
        ServerSocket s = serverSocketCreator.call();
        s.setSoTimeout((int)timeoutMs);
        return s;
    }

    private static Function<ServerSocket, Flowable<Flowable<byte[]>>> createFlowableFactory(final int timeoutMs, final int bufferSize, final Action preAcceptAction, final Predicate<? super Socket> acceptSocket) {
        return new Function<ServerSocket, Flowable<Flowable<byte[]>>>(){

            public Flowable<Flowable<byte[]>> apply(ServerSocket serverSocket) {
                return FlowableServerSocket.createServerSocketFlowable(serverSocket, timeoutMs, bufferSize, preAcceptAction, (Predicate<? super Socket>)acceptSocket);
            }
        };
    }

    private static Flowable<Flowable<byte[]>> createServerSocketFlowable(final ServerSocket serverSocket, final long timeoutMs, final int bufferSize, final Action preAcceptAction, final Predicate<? super Socket> acceptSocket) {
        return Flowable.generate((Consumer)new Consumer<Emitter<Flowable<byte[]>>>(){

            public void accept(Emitter<Flowable<byte[]>> emitter) throws Exception {
                FlowableServerSocket.acceptConnection(timeoutMs, bufferSize, serverSocket, (Emitter<Flowable<byte[]>>)emitter, preAcceptAction, (Predicate<? super Socket>)acceptSocket);
            }
        });
    }

    private static void acceptConnection(long timeoutMs, int bufferSize, ServerSocket ss, Emitter<Flowable<byte[]>> emitter, Action preAcceptAction, Predicate<? super Socket> acceptSocket) {
        while (true) {
            try {
                Socket socket;
                while (true) {
                    preAcceptAction.run();
                    socket = ss.accept();
                    if (acceptSocket.test((Object)socket)) break;
                    FlowableServerSocket.closeQuietly(socket);
                }
                emitter.onNext(FlowableServerSocket.createSocketFlowable(socket, timeoutMs, bufferSize));
            }
            catch (SocketTimeoutException socketTimeoutException) {
                continue;
            }
            catch (Throwable e) {
                if (e instanceof SocketException && ("Socket closed".equals(e.getMessage()) || "Socket operation on nonsocket: configureBlocking".equals(e.getMessage()))) break;
                emitter.onError(e);
            }
            break;
        }
    }

    @VisibleForTesting
    static void closeQuietly(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Exception decompiling
     */
    private static Flowable<byte[]> createSocketFlowable(Socket socket, long timeoutMs, int bufferSize) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setTimeout(Socket socket, long timeoutMs) {
        try {
            socket.setSoTimeout((int)timeoutMs);
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
    }
}

