/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.FlowableSubscriber;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableStringInputStream {
    private FlowableStringInputStream() {
        throw new IllegalStateException("No instances!");
    }

    public static InputStream createInputStream(Publisher<String> source, Charset charset) {
        StringInputStream parent = new StringInputStream(charset);
        source.subscribe((Subscriber)parent);
        return parent;
    }

    static final class StringInputStream
    extends InputStream
    implements FlowableSubscriber<String> {
        final AtomicReference<Subscription> upstream;
        final Charset charset;
        volatile byte[] bytes;
        int index;
        volatile boolean done;
        Throwable error;

        StringInputStream(Charset charset) {
            this.charset = charset;
            this.upstream = new AtomicReference();
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.setOnce(this.upstream, (Subscription)s)) {
                s.request(1L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(String t) {
            this.bytes = t.getBytes(this.charset);
            StringInputStream stringInputStream = this;
            synchronized (stringInputStream) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            StringInputStream stringInputStream = this;
            synchronized (stringInputStream) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            this.done = true;
            StringInputStream stringInputStream = this;
            synchronized (stringInputStream) {
                this.notifyAll();
            }
        }

        @Override
        public int read() throws IOException {
            int idx;
            byte[] a;
            while (true) {
                if ((a = this.awaitBufferIfNecessary()) == null) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new IOException(ex);
                    }
                    return -1;
                }
                idx = this.index;
                if (idx != a.length) break;
                this.index = 0;
                this.bytes = null;
                this.upstream.get().request(1L);
            }
            int result = a[idx] & 0xFF;
            this.index = idx + 1;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte[] awaitBufferIfNecessary() throws IOException {
            byte[] a = this.bytes;
            if (a == null) {
                StringInputStream stringInputStream = this;
                synchronized (stringInputStream) {
                    while (true) {
                        boolean d = this.done;
                        a = this.bytes;
                        if (a != null || d || this.upstream.get() == SubscriptionHelper.CANCELLED) break;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            if (this.upstream.get() == SubscriptionHelper.CANCELLED) break;
                            InterruptedIOException exc = new InterruptedIOException();
                            exc.initCause(ex);
                            throw exc;
                        }
                    }
                }
            }
            return a;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int idx;
            byte[] a;
            if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
                throw new IndexOutOfBoundsException("b.length=" + b.length + ", off=" + off + ", len=" + len);
            }
            while (true) {
                if ((a = this.awaitBufferIfNecessary()) == null) {
                    Throwable ex = this.error;
                    if (ex != null) {
                        if (ex instanceof IOException) {
                            throw (IOException)ex;
                        }
                        throw new IOException(ex);
                    }
                    return -1;
                }
                idx = this.index;
                if (idx != a.length) break;
                this.index = 0;
                this.bytes = null;
                this.upstream.get().request(1L);
            }
            int r = 0;
            while (idx < a.length && len > 0) {
                b[off] = a[idx];
                ++idx;
                ++off;
                ++r;
                --len;
            }
            this.index = idx;
            return r;
        }

        @Override
        public int available() throws IOException {
            byte[] a = this.bytes;
            int idx = this.index;
            return a != null ? Math.max(0, a.length - idx) : 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            SubscriptionHelper.cancel(this.upstream);
            StringInputStream stringInputStream = this;
            synchronized (stringInputStream) {
                this.notifyAll();
            }
        }
    }
}

