/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable;

import io.reactivex.Flowable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;

public final class OnSubscribeCacheResettable<T> {
    private final AtomicBoolean refresh = new AtomicBoolean(true);
    private final Flowable<T> source;
    private volatile Flowable<T> current;

    public OnSubscribeCacheResettable(Flowable<T> source) {
        this.source = source;
        this.current = source;
    }

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.refresh.compareAndSet(true, false)) {
            this.current = this.source.cache();
        }
        this.current.subscribe(subscriber);
    }

    public void reset() {
        this.refresh.set(true);
    }
}

