/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable.buffertofile;

import com.github.davidmoten.rx2.internal.flowable.buffertofile.MemoryMappedFile;
import java.io.File;

public final class Page {
    private static final boolean debug = false;
    private final int pageSize;
    private final MemoryMappedFile mm;

    public Page(File file, int pageSize) {
        this.pageSize = pageSize;
        this.mm = new MemoryMappedFile(file, pageSize);
    }

    public int length() {
        return this.pageSize;
    }

    public void put(int position, byte[] bytes, int start, int length) {
        this.mm.putBytes(position, bytes, start, length);
    }

    public void putIntOrdered(int writePosition, int value) {
        this.mm.putOrderedInt(writePosition, value);
    }

    public void putInt(int writePosition, int value) {
        this.mm.putInt(writePosition, value);
    }

    public void get(byte[] dst, int offset, int readPosition, int length) {
        this.mm.getBytes(readPosition, dst, offset, length);
    }

    public int getIntVolatile(int readPosition) {
        int n = this.mm.getIntVolatile(readPosition);
        return n;
    }

    public void close() {
        this.mm.close();
    }

    static void println(String s) {
        System.out.println(Thread.currentThread().getName() + ": " + s);
    }

    public int avail(int position) {
        return this.pageSize - position;
    }

    public int getInt(int readPosition) {
        return this.mm.getInt(readPosition);
    }

    public void putByte(int currentWritePosition, byte b) {
        this.mm.putByte(currentWritePosition, b);
    }

    public byte getByte(int readPosition) {
        return this.mm.getByte(readPosition);
    }
}

