/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx2.internal.flowable.buffertofile;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rx2.internal.flowable.buffertofile.Pages;
import java.io.File;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class PagedQueue
extends AtomicInteger {
    private static final boolean isLittleEndian = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private static final int EXTRA_PADDING_LIMIT = 64;
    private static final int SIZE_MESSAGE_SIZE_FIELD = 4;
    private static final int SIZE_PADDING_SIZE_FIELD = 1;
    private static final int SIZE_MESSAGE_TYPE_FIELD = 1;
    private static final int ALIGN_BYTES = 4;
    private static final int MAX_PADDING_PER_FULL_MESSAGE = 32;
    private static final int SIZE_HEADER_PRIMARY_PART = 6;
    private final Pages pages;
    private boolean readingFragments;
    private byte[] messageBytesAccumulated;
    private int indexBytesAccumulated;

    public PagedQueue(Callable<File> fileFactory, int pageSize) {
        this.pages = new Pages(fileFactory, pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offer(byte[] bytes) {
        if (this.getAndIncrement() != 0) {
            return;
        }
        try {
            int padding = PagedQueue.padding(bytes.length);
            int avail = this.pages.avail();
            int fullMessageSize = this.fullMessageSize(bytes.length, padding);
            int availAfter = avail - fullMessageSize;
            if (availAfter >= 0) {
                if (availAfter <= 32) {
                    padding += availAfter;
                }
                this.writeFullMessage(bytes, padding);
            } else {
                this.writeFragments(bytes, avail);
            }
        }
        finally {
            this.decrementAndGet();
        }
    }

    private void writeFullMessage(byte[] bytes, int padding) {
        this.write(bytes, 0, bytes.length, padding, MessageType.FULL_MESSAGE, bytes.length);
    }

    private void writeFragments(byte[] bytes, int avail) {
        int start = 0;
        int length = bytes.length;
        do {
            int padding;
            int extraHeaderBytes;
            int count;
            int remaining;
            if ((remaining = Math.max(0, avail - (count = Math.min(avail - 8 - (extraHeaderBytes = start == 0 ? 4 : 0), length)) - 6 - (padding = PagedQueue.padding(count)) - extraHeaderBytes)) <= 64) {
                padding += remaining;
            }
            this.write(bytes, start, count, padding, MessageType.FRAGMENT, bytes.length);
            start += count;
            if ((length -= count) <= 0) continue;
            avail = this.pages.avail();
        } while (length > 0);
    }

    private int fullMessageSize(int payloadLength, int padding) {
        return 6 + padding + payloadLength;
    }

    private static int padding(int payloadLength) {
        int rem = (payloadLength + 1 + 1) % 4;
        int padding = rem == 0 ? 0 : 4 - rem;
        return padding;
    }

    private void write(byte[] bytes, int offset, int length, int padding, MessageType messageType, int totalLength) {
        Preconditions.checkArgument((length != 0 ? 1 : 0) != 0);
        this.pages.markForRewriteAndAdvance4Bytes();
        if (padding == 2 && isLittleEndian) {
            this.pages.putInt((messageType.value() & 0xFF) << 0 | (byte)padding << 8);
        } else {
            this.pages.putByte(messageType.value());
            this.pages.putByte((byte)padding);
            if (padding > 0) {
                this.pages.moveWritePosition(padding);
            }
        }
        if (messageType == MessageType.FRAGMENT && offset == 0) {
            this.pages.putInt(totalLength);
        }
        this.pages.put(bytes, offset, length);
        this.pages.putIntOrderedAtRewriteMark(length);
    }

    public byte[] poll() {
        byte[] result;
        block10: {
            do {
                byte padding;
                MessageType messageType;
                int length;
                if ((length = this.pages.getIntVolatile()) == 0) {
                    this.pages.moveReadPosition(-4);
                    return null;
                }
                if (length == -1) {
                    return null;
                }
                if (length % 4 == 0 && isLittleEndian) {
                    int i = this.pages.getInt();
                    messageType = MessageType.from((byte)i);
                    padding = (byte)(i >> 8 & 0xFF);
                    if (padding > 2) {
                        this.pages.moveReadPosition(padding - 2);
                    }
                } else {
                    messageType = MessageType.from(this.pages.getByte());
                    padding = this.pages.getByte();
                    if (padding > 0) {
                        this.pages.moveReadPosition(padding);
                    }
                }
                if (!this.readingFragments && messageType == MessageType.FRAGMENT) {
                    int lengthRemaining = this.pages.getInt();
                    if (this.messageBytesAccumulated == null) {
                        this.messageBytesAccumulated = new byte[lengthRemaining];
                        this.indexBytesAccumulated = 0;
                    }
                    this.readingFragments = true;
                }
                if ((result = this.pages.get(length)).length == 0) {
                    return null;
                }
                if (!this.readingFragments) break block10;
                System.arraycopy(result, 0, this.messageBytesAccumulated, this.indexBytesAccumulated, result.length);
                this.indexBytesAccumulated += result.length;
            } while (this.indexBytesAccumulated != this.messageBytesAccumulated.length);
            this.readingFragments = false;
            byte[] b = this.messageBytesAccumulated;
            this.messageBytesAccumulated = null;
            return b;
        }
        return result;
    }

    private void closeWrite() {
        this.incrementAndGet();
        while (!this.compareAndSet(1, 2)) {
        }
    }

    public void close() {
        this.closeWrite();
        this.pages.close();
        this.messageBytesAccumulated = null;
    }

    private static enum MessageType {
        FULL_MESSAGE(0),
        FRAGMENT(1);

        private final byte value;

        private MessageType(int value) {
            this.value = (byte)value;
        }

        byte value() {
            return this.value;
        }

        static MessageType from(byte b) {
            if (b == 0) {
                return FULL_MESSAGE;
            }
            if (b == 1) {
                return FRAGMENT;
            }
            throw new RuntimeException("unexpected");
        }
    }
}

