/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class RingBuffer<T>
implements Queue<T> {
    private final T[] list;
    private int start;
    private int finish;

    private RingBuffer(int size) {
        this.list = new Object[size + 1];
    }

    public static <T> RingBuffer<T> create(int size) {
        return new RingBuffer<T>(size);
    }

    @Override
    public void clear() {
        this.finish = this.start;
    }

    @Override
    public Iterator<T> iterator() {
        final int _start = this.start;
        final int _finish = this.finish;
        return new Iterator<T>(){
            int i;
            {
                this.i = _start;
            }

            @Override
            public boolean hasNext() {
                return this.i != _finish;
            }

            @Override
            public T next() {
                Object value = RingBuffer.this.list[this.i];
                this.i = (this.i + 1) % RingBuffer.this.list.length;
                return value;
            }
        };
    }

    @Override
    public T peek() {
        if (this.start == this.finish) {
            return null;
        }
        return this.list[this.start];
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.finish;
    }

    @Override
    public int size() {
        if (this.start <= this.finish) {
            return this.finish - this.start;
        }
        return this.finish - this.start + this.list.length;
    }

    public int maxSize() {
        return this.list.length - 1;
    }

    @Override
    public boolean contains(Object o) {
        return (Boolean)RingBuffer.notImplemented();
    }

    @Override
    public Object[] toArray() {
        return (Object[])RingBuffer.notImplemented();
    }

    @Override
    public <S> S[] toArray(S[] a) {
        return (Object[])RingBuffer.notImplemented();
    }

    @Override
    public boolean remove(Object o) {
        return (Boolean)RingBuffer.notImplemented();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return (Boolean)RingBuffer.notImplemented();
    }

    private static <T> T notImplemented() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        for (T t : c) {
            this.add(t);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return (Boolean)RingBuffer.notImplemented();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return (Boolean)RingBuffer.notImplemented();
    }

    @Override
    public boolean add(T t) {
        if (this.offer(t)) {
            return true;
        }
        throw new IllegalStateException("Cannot add to queue because is full");
    }

    @Override
    public boolean offer(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        int currentFinish = this.finish;
        this.finish = (this.finish + 1) % this.list.length;
        if (this.finish == this.start) {
            return false;
        }
        this.list[currentFinish] = t;
        return true;
    }

    @Override
    public T remove() {
        T t = this.poll();
        if (t == null) {
            throw new NoSuchElementException();
        }
        return t;
    }

    @Override
    public T poll() {
        if (this.start == this.finish) {
            return null;
        }
        T value = this.list[this.start];
        this.list[this.start] = null;
        this.start = (this.start + 1) % this.list.length;
        return value;
    }

    @Override
    public T element() {
        return RingBuffer.notImplemented();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("RingBuffer[");
        boolean first = true;
        for (T value : this) {
            if (!first) {
                s.append(", ");
            } else {
                first = false;
            }
            s.append(String.valueOf(value));
        }
        s.append("]");
        return s.toString();
    }
}

