/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.internal;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSingleDeferUntilRequest<T>
extends Flowable<T> {
    private final Single<T> single;

    public FlowableSingleDeferUntilRequest(Single<T> single) {
        this.single = single;
    }

    protected void subscribeActual(Subscriber<? super T> s) {
        SingleSubscription<? super T> sub = new SingleSubscription<T>(this.single, s);
        s.onSubscribe(sub);
    }

    private static final class SingleSubscription<T>
    extends AtomicBoolean
    implements Subscription,
    SingleObserver<T> {
        private static final long serialVersionUID = -4290226935675014466L;
        private final Subscriber<? super T> s;
        private final Single<T> single;
        private final AtomicReference<Disposable> disposable = new AtomicReference();

        SingleSubscription(Single<T> single, Subscriber<? super T> s) {
            this.single = single;
            this.s = s;
        }

        public void request(long n) {
            Disposable d;
            if (n > 0L && this.compareAndSet(false, true) && (d = this.disposable.get()) == null) {
                this.single.subscribe((SingleObserver)this);
            }
        }

        public void cancel() {
            if (this.disposable.compareAndSet(null, Disposables.disposed())) {
                return;
            }
            this.disposable.get().dispose();
            this.disposable.set(Disposables.disposed());
        }

        public void onSubscribe(Disposable d) {
            if (!this.disposable.compareAndSet(null, d)) {
                d.dispose();
                this.disposable.set(Disposables.disposed());
            }
        }

        public void onSuccess(T t) {
            this.s.onNext(t);
            this.s.onComplete();
        }

        public void onError(Throwable e) {
            this.s.onError(e);
        }
    }
}

