/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Lists;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Notification;
import io.reactivex.Single;
import io.reactivex.functions.BiConsumer;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.davidmoten.rx.jdbc.CallableBuilder;
import org.davidmoten.rx.jdbc.NamedCallableStatement;
import org.davidmoten.rx.jdbc.Type;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.tuple.Tuple2;
import org.davidmoten.rx.jdbc.tuple.Tuple3;
import org.davidmoten.rx.jdbc.tuple.Tuple4;
import org.davidmoten.rx.jdbc.tuple.TupleN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Call {
    private static final Logger log = LoggerFactory.getLogger(Call.class);

    private Call() {
    }

    public static Completable createWithZeroOutParameters(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithZeroOutParameters(stmt, parameters, parameterPlaceholders))).dematerialize().ignoreElements();
    }

    private static Single<Object> createWithZeroOutParameters(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            Call.execute(stmt, parameters, parameterPlaceholders, 0, st);
            return 1;
        });
    }

    public static <T1> Flowable<Notification<T1>> createWithOneOutParameter(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithOneParameter(stmt, parameters, parameterPlaceholders, cls)));
    }

    private static <T> Single<T> createWithOneParameter(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T> cls1) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, 2, st);
            return Util.mapObject(st, cls1, outs.get((int)0).pos, outs.get((int)0).type);
        });
    }

    public static <T1, T2> Flowable<Notification<Tuple2<T1, T2>>> createWithTwoOutParameters(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithTwoParameters(stmt, parameters, parameterPlaceholders, cls1, cls2)));
    }

    private static <T1, T2> Single<Tuple2<T1, T2>> createWithTwoParameters(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, 2, st);
            Object o1 = Util.mapObject(st, cls1, outs.get((int)0).pos, outs.get((int)0).type);
            Object o2 = Util.mapObject(st, cls2, outs.get((int)1).pos, outs.get((int)1).type);
            return Tuple2.create(o1, o2);
        });
    }

    public static <T1, T2, T3> Flowable<Notification<Tuple3<T1, T2, T3>>> createWithThreeOutParameters(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithThreeParameters(stmt, parameters, parameterPlaceholders, cls1, cls2, cls3)));
    }

    private static <T1, T2, T3> Single<Tuple3<T1, T2, T3>> createWithThreeParameters(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, 3, st);
            Object o1 = Util.mapObject(st, cls1, outs.get((int)0).pos, outs.get((int)0).type);
            Object o2 = Util.mapObject(st, cls2, outs.get((int)1).pos, outs.get((int)1).type);
            Object o3 = Util.mapObject(st, cls3, outs.get((int)2).pos, outs.get((int)2).type);
            return Tuple3.create(o1, o2, o3);
        });
    }

    public static <T1, T2, T3, T4> Flowable<Notification<Tuple4<T1, T2, T3, T4>>> createWithFourOutParameters(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithFourParameters(stmt, parameters, parameterPlaceholders, cls1, cls2, cls3, cls4)));
    }

    private static <T1, T2, T3, T4> Single<Tuple4<T1, T2, T3, T4>> createWithFourParameters(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, 4, st);
            Object o1 = Util.mapObject(st, cls1, outs.get((int)0).pos, outs.get((int)0).type);
            Object o2 = Util.mapObject(st, cls2, outs.get((int)1).pos, outs.get((int)1).type);
            Object o3 = Util.mapObject(st, cls3, outs.get((int)2).pos, outs.get((int)2).type);
            Object o4 = Util.mapObject(st, cls4, outs.get((int)3).pos, outs.get((int)3).type);
            return Tuple4.create(o1, o2, o3, o4);
        });
    }

    public static Flowable<?> createWithNParameters(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, List<Class<?>> outClasses) {
        return connection.toFlowable().flatMap(con -> Call.createWithParameters(con, sql, parameterGroups, parameterPlaceholders, (stmt, parameters) -> Call.createWithNParameters(stmt, parameters, parameterPlaceholders, outClasses)));
    }

    private static Single<TupleN<Object>> createWithNParameters(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, List<Class<?>> outClasses) {
        return Single.fromCallable(() -> {
            CallableStatement st = stmt.stmt;
            List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, Integer.MAX_VALUE, st);
            Object[] outputs = new Object[outClasses.size()];
            for (int i = 0; i < outClasses.size(); ++i) {
                outputs[i] = Util.mapObject(st, (Class)outClasses.get(i), outs.get((int)i).pos, outs.get((int)i).type);
            }
            return TupleN.create(outputs);
        });
    }

    public static <T1> Flowable<Notification<CallableBuilder.CallableResultSet1<T1>>> createWithOneResultSet(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, int fetchSize) {
        return connection.toFlowable().flatMap(con -> Call.createWithOneResultSet(con, sql, parameterGroups, parameterPlaceholders, f1, fetchSize));
    }

    private static <T1> Flowable<Notification<CallableBuilder.CallableResultSet1<T1>>> createWithOneResultSet(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, int fetchSize) {
        log.debug("Update.create {}", (Object)sql);
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> {
            List<Object> outputValues = Call.executeAndReturnOutputValues(parameterPlaceholders, stmt, parameters);
            Flowable flowable1 = Call.createFlowable(stmt, f1);
            return Single.just(new CallableBuilder.CallableResultSet1(outputValues, flowable1)).toFlowable();
        }).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    public static <T1, T2> Flowable<Notification<CallableBuilder.CallableResultSet2<T1, T2>>> createWithTwoResultSets(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, int fetchSize) {
        return connection.toFlowable().flatMap(con -> Call.createWithTwoResultSets(con, sql, parameterGroups, parameterPlaceholders, f1, f2, fetchSize));
    }

    private static <T1, T2> Flowable<Notification<CallableBuilder.CallableResultSet2<T1, T2>>> createWithTwoResultSets(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, int fetchSize) {
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> {
            List<Object> outputValues = Call.executeAndReturnOutputValues(parameterPlaceholders, stmt, parameters);
            Flowable flowable1 = Call.createFlowable(stmt, f1);
            stmt.stmt.getMoreResults(2);
            Flowable flowable2 = Call.createFlowable(stmt, f2);
            return Single.just(new CallableBuilder.CallableResultSet2(outputValues, flowable1, flowable2)).toFlowable();
        }).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    public static <T1, T2, T3> Flowable<Notification<CallableBuilder.CallableResultSet3<T1, T2, T3>>> createWithThreeResultSets(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, int fetchSize) {
        return connection.toFlowable().flatMap(con -> Call.createWithThreeResultSets(con, sql, parameterGroups, parameterPlaceholders, f1, f2, f3, fetchSize));
    }

    private static <T1, T2, T3> Flowable<Notification<CallableBuilder.CallableResultSet3<T1, T2, T3>>> createWithThreeResultSets(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, int fetchSize) {
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> {
            List<Object> outputValues = Call.executeAndReturnOutputValues(parameterPlaceholders, stmt, parameters);
            Flowable flowable1 = Call.createFlowable(stmt, f1);
            stmt.stmt.getMoreResults(2);
            Flowable flowable2 = Call.createFlowable(stmt, f2);
            stmt.stmt.getMoreResults(2);
            Flowable flowable3 = Call.createFlowable(stmt, f3);
            return Single.just(new CallableBuilder.CallableResultSet3(outputValues, flowable1, flowable2, flowable3)).toFlowable();
        }).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    public static <T1, T2, T3, T4> Flowable<Notification<CallableBuilder.CallableResultSet4<T1, T2, T3, T4>>> createWithFourResultSets(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, Function<? super ResultSet, ? extends T4> f4, int fetchSize) {
        return connection.toFlowable().flatMap(con -> Call.createWithFourResultSets(con, sql, parameterGroups, parameterPlaceholders, f1, f2, f3, f4, fetchSize));
    }

    private static <T1, T2, T3, T4> Flowable<Notification<CallableBuilder.CallableResultSet4<T1, T2, T3, T4>>> createWithFourResultSets(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, Function<? super ResultSet, ? extends T4> f4, int fetchSize) {
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> {
            List<Object> outputValues = Call.executeAndReturnOutputValues(parameterPlaceholders, stmt, parameters);
            Flowable flowable1 = Call.createFlowable(stmt, f1);
            stmt.stmt.getMoreResults(2);
            Flowable flowable2 = Call.createFlowable(stmt, f2);
            stmt.stmt.getMoreResults(2);
            Flowable flowable3 = Call.createFlowable(stmt, f3);
            stmt.stmt.getMoreResults(2);
            Flowable flowable4 = Call.createFlowable(stmt, f4);
            return Single.just(new CallableBuilder.CallableResultSet4(outputValues, flowable1, flowable2, flowable3, flowable4)).toFlowable();
        }).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    public static Flowable<Notification<CallableBuilder.CallableResultSetN>> createWithNResultSets(Single<Connection> connection, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, List<Function<? super ResultSet, ?>> functions, int fetchSize) {
        return connection.toFlowable().flatMap(con -> Call.createWithNResultSets(con, sql, parameterGroups, parameterPlaceholders, functions, fetchSize));
    }

    private static Flowable<Notification<CallableBuilder.CallableResultSetN>> createWithNResultSets(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, List<Function<? super ResultSet, ?>> functions, int fetchSize) {
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> {
            List<Object> outputValues = Call.executeAndReturnOutputValues(parameterPlaceholders, stmt, parameters);
            ArrayList flowables = Lists.newArrayList();
            int i = 0;
            do {
                Function f = (Function)functions.get(i);
                flowables.add(Call.createFlowable(stmt, f));
                ++i;
            } while (stmt.stmt.getMoreResults(2));
            return Single.just((Object)new CallableBuilder.CallableResultSetN(outputValues, flowables)).toFlowable();
        }).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    private static <T> Flowable<Notification<T>> createWithParameters(Connection con, String sql, Flowable<List<Object>> parameterGroups, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, BiFunction<NamedCallableStatement, List<Object>, Single<T>> single) {
        Callable<NamedCallableStatement> resourceFactory = () -> Util.prepareCall(con, sql, parameterPlaceholders);
        Function flowableFactory = stmt -> parameterGroups.flatMap(parameters -> ((Single)single.apply(stmt, parameters)).toFlowable()).materialize().doOnComplete(() -> Util.commit(stmt.stmt)).doOnError(e -> Util.rollback(stmt.stmt));
        Consumer disposer = Util::closeCallableStatementAndConnection;
        return Flowable.using(resourceFactory, (Function)flowableFactory, (Consumer)disposer, (boolean)true);
    }

    static PreparedStatement setParameters(PreparedStatement ps, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, List<String> names) throws SQLException {
        if (names.isEmpty()) {
            int i = 0;
            for (int j = 0; j < parameterPlaceholders.size() && i < parameters.size(); ++j) {
                CallableBuilder.ParameterPlaceholder p = parameterPlaceholders.get(j);
                if (!(p instanceof CallableBuilder.InParameterPlaceholder)) continue;
                Util.setParameter(ps, j + 1, parameters.get(i));
                ++i;
            }
        } else {
            throw new RuntimeException("named paramters not implemented yet for CallableStatement yet");
        }
        return ps;
    }

    private static List<PlaceAndType> execute(NamedCallableStatement stmt, List<Object> parameters, List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, int outCount, CallableStatement st) throws SQLException {
        Util.incrementCounter(st.getConnection());
        Call.setParameters(st, parameters, parameterPlaceholders, stmt.names);
        int initialSize = outCount == Integer.MAX_VALUE ? 16 : outCount;
        ArrayList<PlaceAndType> outs = new ArrayList<PlaceAndType>(initialSize);
        for (int j = 0; j < parameterPlaceholders.size(); ++j) {
            CallableBuilder.ParameterPlaceholder p = parameterPlaceholders.get(j);
            if (!(p instanceof CallableBuilder.OutParameterPlaceholder)) continue;
            outs.add(new PlaceAndType(j + 1, ((CallableBuilder.OutParameterPlaceholder)p).type()));
            if (outs.size() == outCount) break;
        }
        st.execute();
        return outs;
    }

    private static <T> Flowable<T> createFlowable(NamedCallableStatement stmt, Function<? super ResultSet, ? extends T> f) throws SQLException {
        ResultSet rsActual = stmt.stmt.getResultSet();
        Callable<ResultSet> initialState = () -> rsActual;
        BiConsumer generator = (rs, emitter) -> {
            log.debug("getting row from ps={}, rs={}", (Object)stmt.stmt, rs);
            if (rs.next()) {
                Object v = f.apply(rs);
                log.debug("emitting {}", v);
                emitter.onNext(v);
            } else {
                log.debug("completed");
                emitter.onComplete();
            }
        };
        Consumer disposeState = Util::closeSilently;
        return Flowable.generate(initialState, (BiConsumer)generator, (Consumer)disposeState);
    }

    private static List<Object> executeAndReturnOutputValues(List<CallableBuilder.ParameterPlaceholder> parameterPlaceholders, NamedCallableStatement stmt, List<Object> parameters) throws SQLException {
        List<PlaceAndType> outs = Call.execute(stmt, parameters, parameterPlaceholders, Integer.MAX_VALUE, stmt.stmt);
        ArrayList<Object> list = new ArrayList<Object>(outs.size());
        for (PlaceAndType p : outs) {
            list.add(stmt.stmt.getObject(p.pos));
        }
        return list;
    }

    private static final class PlaceAndType {
        final int pos;
        final Type type;

        PlaceAndType(int pos, Type type) {
            this.pos = pos;
            this.type = type;
        }
    }
}

