/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.davidmoten.rx.jdbc.Call;
import org.davidmoten.rx.jdbc.Type;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.callable.internal.Getter1;
import org.davidmoten.rx.jdbc.callable.internal.Getter2;
import org.davidmoten.rx.jdbc.callable.internal.Getter3;
import org.davidmoten.rx.jdbc.callable.internal.Getter4;
import org.davidmoten.rx.jdbc.callable.internal.GetterN;
import org.davidmoten.rx.jdbc.tuple.Tuple2;
import org.davidmoten.rx.jdbc.tuple.Tuple3;
import org.davidmoten.rx.jdbc.tuple.Tuple4;
import org.davidmoten.rx.jdbc.tuple.TupleN;

public final class CallableBuilder
implements Getter1 {
    final String sql;
    final List<ParameterPlaceholder> params = new ArrayList<ParameterPlaceholder>();
    Flowable<?> inStream;
    private final Single<Connection> connection;
    private static final In IN = new In();

    public CallableBuilder(String sql, Single<Connection> connection) {
        this.sql = sql;
        this.connection = connection;
    }

    public Flowable<List<Object>> parameterGroups() {
        int numInParameters = this.params.stream().filter(x -> x instanceof InParameterPlaceholder).collect(Collectors.counting()).intValue();
        if (numInParameters == 0) {
            return this.inStream.map(x -> Collections.singletonList(x));
        }
        return this.inStream.buffer(numInParameters);
    }

    public CallableBuilder in() {
        this.params.add(IN);
        return this;
    }

    public Completable in(Flowable<?> f) {
        Preconditions.checkArgument((this.inStream == null ? 1 : 0) != 0, (String)("you can only specify in flowable once, current=" + this.inStream));
        this.inStream = f;
        return this.build();
    }

    public Completable once() {
        return this.in(1);
    }

    public Completable in(Object ... objects) {
        return this.in(Flowable.fromArray((Object[])objects));
    }

    public <T> CallableBuilder1<T> inOut(Type type, Class<T> cls) {
        this.params.add(new InOut(type, cls));
        return new CallableBuilder1<T>(this, cls);
    }

    public <T> CallableBuilder1<T> out(Type type, Class<T> cls) {
        this.params.add(new Out(type, cls));
        return new CallableBuilder1<T>(this, cls);
    }

    @Override
    public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
        return new CallableResultSets1Builder<T>(this, function);
    }

    public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
        return this.get(Util.autoMap(cls));
    }

    private Completable build() {
        return Call.createWithZeroOutParameters(this.connection, this.sql, this.parameterGroups(), this.params);
    }

    private static <T> List<T> createList(List<T> list, T t) {
        ArrayList<T> r = new ArrayList<T>(list);
        r.add(t);
        return r;
    }

    static final class Out
    implements OutParameterPlaceholder {
        final Type type;
        final Class<?> cls;

        public Out(Type type, Class<?> cls) {
            this.type = type;
            this.cls = cls;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }

    static final class InOut
    implements InParameterPlaceholder,
    OutParameterPlaceholder {
        final Type type;
        final Class<?> cls;

        InOut(Type type, Class<?> cls) {
            this.type = type;
            this.cls = cls;
        }

        @Override
        public Type type() {
            return this.type;
        }
    }

    static final class In
    implements InParameterPlaceholder {
        In() {
        }
    }

    static interface InParameterPlaceholder
    extends ParameterPlaceholder {
    }

    static interface OutParameterPlaceholder
    extends ParameterPlaceholder {
        public Type type();
    }

    static interface ParameterPlaceholder {
    }

    public static final class CallableResultSetN {
        private final List<Object> outs;
        private final List<Flowable<?>> flowables;

        public CallableResultSetN(List<Object> outs, List<Flowable<?>> flowables) {
            this.outs = outs;
            this.flowables = flowables;
        }

        public List<Flowable<?>> results() {
            return this.flowables;
        }

        public Flowable<?> results(int index) {
            return this.flowables.get(index);
        }

        public List<Object> outs() {
            return this.outs;
        }
    }

    public static final class CallableResultSet4<T1, T2, T3, T4> {
        private final List<Object> outs;
        private final Flowable<T1> results1;
        private final Flowable<T2> results2;
        private final Flowable<T3> results3;
        private final Flowable<T4> results4;

        public CallableResultSet4(List<Object> outs, Flowable<T1> query1, Flowable<T2> query2, Flowable<T3> query3, Flowable<T4> query4) {
            this.outs = outs;
            this.results1 = query1;
            this.results2 = query2;
            this.results3 = query3;
            this.results4 = query4;
        }

        public Flowable<T1> results1() {
            return this.results1;
        }

        public Flowable<T2> results2() {
            return this.results2;
        }

        public Flowable<T3> results3() {
            return this.results3;
        }

        public Flowable<T4> results4() {
            return this.results4;
        }

        public List<Object> outs() {
            return this.outs;
        }
    }

    public static final class CallableResultSet3<T1, T2, T3> {
        private final List<Object> outs;
        private final Flowable<T1> results1;
        private final Flowable<T2> results2;
        private final Flowable<T3> results3;

        public CallableResultSet3(List<Object> outs, Flowable<T1> query1, Flowable<T2> query2, Flowable<T3> query3) {
            this.outs = outs;
            this.results1 = query1;
            this.results2 = query2;
            this.results3 = query3;
        }

        public Flowable<T1> results1() {
            return this.results1;
        }

        public Flowable<T2> results2() {
            return this.results2;
        }

        public Flowable<T3> results3() {
            return this.results3;
        }

        public List<Object> outs() {
            return this.outs;
        }
    }

    public static final class CallableResultSet2<T1, T2> {
        private final List<Object> outs;
        private final Flowable<T1> results1;
        private final Flowable<T2> results2;

        public CallableResultSet2(List<Object> outs, Flowable<T1> results1, Flowable<T2> results2) {
            this.outs = outs;
            this.results1 = results1;
            this.results2 = results2;
        }

        public Flowable<T1> results1() {
            return this.results1;
        }

        public Flowable<T2> results2() {
            return this.results2;
        }

        public List<Object> outs() {
            return this.outs;
        }
    }

    public static final class CallableResultSet1<T1> {
        private final List<Object> outs;
        private final Flowable<T1> results;

        public CallableResultSet1(List<Object> outs, Flowable<T1> results) {
            this.outs = outs;
            this.results = results;
        }

        public Flowable<T1> results() {
            return this.results;
        }

        public List<Object> outs() {
            return this.outs;
        }
    }

    public static final class CallableResultSetsNBuilder {
        private final CallableBuilder b;
        private final List<Function<? super ResultSet, ?>> functions;

        CallableResultSetsNBuilder(CallableBuilder b, List<Function<? super ResultSet, ?>> functions) {
            this.b = b;
            this.functions = functions;
        }

        public CallableResultSetsNBuilder in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSetN> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public Flowable<CallableResultSetN> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSetsNBuilder inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T> CallableResultSetsNBuilder autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        public CallableResultSetsNBuilder get(Function<? super ResultSet, ?> f) {
            this.functions.add(f);
            return this;
        }

        private Flowable<CallableResultSetN> build() {
            return Call.createWithNResultSets((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.functions, 0).dematerialize();
        }
    }

    public static final class CallableResultSets4Builder<T1, T2, T3, T4>
    implements GetterN {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;
        private final Function<? super ResultSet, ? extends T3> f3;
        private final Function<? super ResultSet, ? extends T4> f4;

        CallableResultSets4Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3, Function<? super ResultSet, ? extends T4> f4) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
            this.f4 = f4;
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets4Builder<T1, T2, T3, T4> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T> CallableResultSetsNBuilder autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public CallableResultSetsNBuilder get(Function<? super ResultSet, ?> f5) {
            return new CallableResultSetsNBuilder(this.b, Lists.newArrayList((Object[])new Function[]{this.f1, this.f2, this.f3, this.f4, f5}));
        }

        public Flowable<CallableResultSet4<T1, T2, T3, T4>> build() {
            return Call.createWithFourResultSets((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, this.f3, this.f4, 0).dematerialize();
        }
    }

    public static final class CallableResultSets3Builder<T1, T2, T3>
    implements Getter4<T1, T2, T3> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;
        private final Function<? super ResultSet, ? extends T3> f3;

        CallableResultSets3Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2, Function<? super ResultSet, ? extends T3> f3) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
            this.f3 = f3;
        }

        public CallableResultSets3Builder<T1, T2, T3> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public CallableResultSets3Builder<T1, T2, T3> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet3<T1, T2, T3>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public Flowable<CallableResultSet3<T1, T2, T3>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets3Builder<T1, T2, T3> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T4> CallableResultSets4Builder<T1, T2, T3, T4> autoMap(Class<T4> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T4> CallableResultSets4Builder<T1, T2, T3, T4> get(Function<? super ResultSet, ? extends T4> f4) {
            return new CallableResultSets4Builder<T1, T2, T3, T4>(this.b, this.f1, this.f2, this.f3, f4);
        }

        private Flowable<CallableResultSet3<T1, T2, T3>> build() {
            return Call.createWithThreeResultSets((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, this.f3, 0).dematerialize();
        }
    }

    public static final class CallableResultSets2Builder<T1, T2>
    implements Getter3<T1, T2> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;
        private final Function<? super ResultSet, ? extends T2> f2;

        CallableResultSets2Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> f1, Function<? super ResultSet, ? extends T2> f2) {
            this.b = b;
            this.f1 = f1;
            this.f2 = f2;
        }

        public CallableResultSets2Builder<T1, T2> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public Flowable<CallableResultSet2<T1, T2>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableResultSets2Builder<T1, T2> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet2<T1, T2>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets2Builder<T1, T2> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        public <T3> CallableResultSets3Builder<T1, T2, T3> autoMap(Class<T3> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T3> CallableResultSets3Builder<T1, T2, T3> get(Function<? super ResultSet, ? extends T3> f3) {
            return new CallableResultSets3Builder<T1, T2, T3>(this.b, this.f1, this.f2, f3);
        }

        private Flowable<CallableResultSet2<T1, T2>> build() {
            return Call.createWithTwoResultSets((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, this.f2, 0).dematerialize();
        }
    }

    public static final class CallableResultSets1Builder<T1>
    implements Getter2<T1> {
        private final CallableBuilder b;
        private final Function<? super ResultSet, ? extends T1> f1;

        CallableResultSets1Builder(CallableBuilder b, Function<? super ResultSet, ? extends T1> function) {
            this.b = b;
            this.f1 = function;
        }

        public CallableResultSets1Builder<T1> out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return this;
        }

        public <T2> CallableResultSets2Builder<T1, T2> autoMap(Class<T2> cls) {
            return this.get(Util.autoMap(cls));
        }

        @Override
        public <T2> CallableResultSets2Builder<T1, T2> get(Function<? super ResultSet, ? extends T2> f2) {
            return new CallableResultSets2Builder<T1, T2>(this.b, this.f1, f2);
        }

        public Flowable<CallableResultSet1<T1>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableResultSets1Builder<T1> in() {
            this.b.in();
            return this;
        }

        public Flowable<CallableResultSet1<T1>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableResultSets1Builder<T1> inOut(Type type, Class<?> cls) {
            this.b.inOut(type, cls);
            return this;
        }

        private Flowable<CallableResultSet1<T1>> build() {
            return Call.createWithOneResultSet((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.f1, 0).dematerialize();
        }
    }

    public static final class CallableBuilderN
    implements Getter1 {
        private final CallableBuilder b;
        private final List<Class<?>> outClasses;

        public CallableBuilderN(CallableBuilder b, List<Class<?>> outClasses) {
            this.b = b;
            this.outClasses = outClasses;
        }

        public Flowable<TupleN<Object>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableBuilderN in() {
            this.b.in();
            return this;
        }

        public Flowable<TupleN<Object>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableBuilderN out(Type type, Class<?> cls) {
            this.b.out(type, cls);
            return new CallableBuilderN(this.b, CallableBuilder.createList(this.outClasses, cls));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<TupleN<Object>> build() {
            return Call.createWithNParameters((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.outClasses).dematerialize();
        }
    }

    public static final class CallableBuilder4<T1, T2, T3, T4>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;
        private final Class<T3> cls3;
        private final Class<T4> cls4;

        public CallableBuilder4(CallableBuilder b, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3, Class<T4> cls4) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
            this.cls3 = cls3;
            this.cls4 = cls4;
        }

        public Flowable<Tuple4<T1, T2, T3, T4>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableBuilder4<T1, T2, T3, T4> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple4<T1, T2, T3, T4>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public CallableBuilderN inOut(Type type, Class<T3> cls5) {
            this.b.inOut(type, cls5);
            return new CallableBuilderN(this.b, Lists.newArrayList((Object[])new Class[]{this.cls1, this.cls2, this.cls3, this.cls4, cls5}));
        }

        public CallableBuilderN out(Type type, Class<?> cls5) {
            this.b.out(type, cls5);
            return new CallableBuilderN(this.b, Lists.newArrayList((Object[])new Class[]{this.cls1, this.cls2, this.cls3, this.cls4, cls5}));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple4<T1, T2, T3, T4>> build() {
            return Call.createWithFourOutParameters((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2, this.cls3, this.cls4).dematerialize();
        }
    }

    public static final class CallableBuilder3<T1, T2, T3>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;
        private final Class<T3> cls3;

        public CallableBuilder3(CallableBuilder b, Class<T1> cls1, Class<T2> cls2, Class<T3> cls3) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
            this.cls3 = cls3;
        }

        public <T4> CallableBuilder4<T1, T2, T3, T4> out(Type type, Class<T4> cls4) {
            this.b.out(type, cls4);
            return new CallableBuilder4<T1, T2, T3, T4>(this.b, this.cls1, this.cls2, this.cls3, cls4);
        }

        public Flowable<Tuple3<T1, T2, T3>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableBuilder3<T1, T2, T3> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple3<T1, T2, T3>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public <T4> CallableBuilder4<T1, T2, T3, T4> inOut(Type type, Class<T4> cls4) {
            this.b.inOut(type, cls4);
            return new CallableBuilder4<T1, T2, T3, T4>(this.b, this.cls1, this.cls2, this.cls3, cls4);
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple3<T1, T2, T3>> build() {
            return Call.createWithThreeOutParameters((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2, this.cls3).dematerialize();
        }
    }

    public static final class CallableBuilder2<T1, T2>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls1;
        private final Class<T2> cls2;

        public CallableBuilder2(CallableBuilder b, Class<T1> cls1, Class<T2> cls2) {
            this.b = b;
            this.cls1 = cls1;
            this.cls2 = cls2;
        }

        public <T3> CallableBuilder3<T1, T2, T3> out(Type type, Class<T3> cls3) {
            this.b.out(type, cls3);
            return new CallableBuilder3<T1, T2, T3>(this.b, this.cls1, this.cls2, cls3);
        }

        public Flowable<Tuple2<T1, T2>> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public CallableBuilder2<T1, T2> in() {
            this.b.in();
            return this;
        }

        public Flowable<Tuple2<T1, T2>> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        public <T3> CallableBuilder3<T1, T2, T3> inOut(Type type, Class<T3> cls3) {
            this.b.inOut(type, cls3);
            return new CallableBuilder3<T1, T2, T3>(this.b, this.cls1, this.cls2, cls3);
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<Tuple2<T1, T2>> build() {
            return Call.createWithTwoOutParameters((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls1, this.cls2).dematerialize();
        }
    }

    public static final class CallableBuilder1<T1>
    implements Getter1 {
        private final CallableBuilder b;
        private final Class<T1> cls;

        public CallableBuilder1(CallableBuilder b, Class<T1> cls) {
            this.b = b;
            this.cls = cls;
        }

        public CallableBuilder1<T1> in() {
            this.b.in();
            return this;
        }

        public <T2> CallableBuilder2<T1, T2> out(Type type, Class<T2> cls2) {
            this.b.out(type, cls2);
            return new CallableBuilder2<T1, T2>(this.b, this.cls, cls2);
        }

        public <T2> CallableBuilder2<T1, T2> inOut(Type type, Class<T2> cls2) {
            this.b.inOut(type, cls2);
            return new CallableBuilder2<T1, T2>(this.b, this.cls, cls2);
        }

        public Flowable<T1> in(Flowable<?> f) {
            this.b.in(f);
            return this.build();
        }

        public Flowable<T1> in(Object ... objects) {
            return this.in(Flowable.fromArray((Object[])objects));
        }

        @Override
        public <T> CallableResultSets1Builder<T> get(Function<? super ResultSet, ? extends T> function) {
            return new CallableResultSets1Builder<T>(this.b, function);
        }

        public <T> CallableResultSets1Builder<T> autoMap(Class<T> cls) {
            return this.get(Util.autoMap(cls));
        }

        private Flowable<T1> build() {
            return Call.createWithOneOutParameter((Single<Connection>)this.b.connection, this.b.sql, this.b.parameterGroups(), this.b.params, this.cls).dematerialize();
        }
    }
}

