/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import java.util.List;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.DependsOn;
import org.davidmoten.rx.jdbc.Getter;
import org.davidmoten.rx.jdbc.ParametersBuilder;
import org.davidmoten.rx.jdbc.ResultSetMapper;
import org.davidmoten.rx.jdbc.Select;
import org.davidmoten.rx.jdbc.TransactedSelectBuilder;

public final class SelectBuilder
extends ParametersBuilder<SelectBuilder>
implements Getter,
DependsOn<SelectBuilder> {
    final String sql;
    final Single<Connection> connections;
    private final Database db;
    int fetchSize = 0;
    private Flowable<?> dependsOn;

    public SelectBuilder(String sql, Single<Connection> connections, Database db) {
        super(sql);
        Preconditions.checkNotNull((Object)sql);
        Preconditions.checkNotNull(connections);
        this.sql = sql;
        this.connections = connections;
        this.db = db;
    }

    public SelectBuilder fetchSize(int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        this.fetchSize = size;
        return this;
    }

    public TransactedSelectBuilder transacted() {
        return new TransactedSelectBuilder(this, this.db);
    }

    public TransactedSelectBuilder transactedValuesOnly() {
        return this.transacted().transactedValuesOnly();
    }

    @Override
    public <T> Flowable<T> get(@Nonnull ResultSetMapper<? extends T> mapper) {
        Preconditions.checkNotNull(mapper, (String)"mapper cannot be null");
        Flowable<List<Object>> pg = super.parameterGroupsToFlowable();
        Flowable f = Select.create(this.connections, pg, this.sql, this.fetchSize, mapper, true);
        if (this.dependsOn != null) {
            return this.dependsOn.ignoreElements().andThen(f);
        }
        return f;
    }

    @Override
    public SelectBuilder dependsOn(@Nonnull Flowable<?> flowable) {
        Preconditions.checkArgument((this.dependsOn == null ? 1 : 0) != 0, (String)"can only set dependsOn once");
        Preconditions.checkNotNull(flowable);
        this.dependsOn = flowable;
        return this;
    }
}

