/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.Select;
import org.davidmoten.rx.jdbc.SelectAutomappedBuilder;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.TxImpl;
import org.davidmoten.rx.jdbc.Util;

public final class TransactedSelectAutomappedBuilder<T> {
    private final SelectAutomappedBuilder<T> selectBuilder;
    private final Database db;
    private boolean valuesOnly = false;

    TransactedSelectAutomappedBuilder(SelectAutomappedBuilder<T> selectBuilder, Database db) {
        this.selectBuilder = selectBuilder;
        this.db = db;
    }

    public TransactedSelectAutomappedBuilder<T> parameters(@Nonnull Flowable<List<Object>> parameters) {
        this.selectBuilder.parameters(parameters);
        return this;
    }

    public TransactedSelectAutomappedBuilder<T> parameters(@Nonnull List<?> values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public TransactedSelectAutomappedBuilder<T> parameter(@Nonnull String name, Object value) {
        this.selectBuilder.parameter(name, value);
        return this;
    }

    public TransactedSelectAutomappedBuilder<T> parameters(Object ... values) {
        this.selectBuilder.parameters(values);
        return this;
    }

    public TransactedSelectAutomappedBuilder<T> parameter(Object value) {
        this.selectBuilder.parameters(value);
        return this;
    }

    public TransactedSelectAutomappedBuilder<T> transactedValuesOnly() {
        this.valuesOnly = true;
        return this;
    }

    public TransactedSelectAutomappedBuilderValuesOnly<T> valuesOnly() {
        return new TransactedSelectAutomappedBuilderValuesOnly(this, this.db);
    }

    public Flowable<Tx<T>> get() {
        Flowable<Tx<T>> o = TransactedSelectAutomappedBuilder.createFlowable(this.selectBuilder, this.db);
        if (this.valuesOnly) {
            return o.filter(tx -> tx.isValue());
        }
        return o;
    }

    private static <T> Flowable<Tx<T>> createFlowable(SelectAutomappedBuilder<T> sb, Database db) {
        return Flowable.defer(() -> {
            AtomicReference connection = new AtomicReference();
            return Select.create((Single<Connection>)sb.selectBuilder.connections.map(c -> Util.toTransactedConnection(connection, c)), sb.selectBuilder.parameterGroupsToFlowable(), sb.selectBuilder.sql, sb.selectBuilder.fetchSize, rs -> Util.mapObject(rs, sb.cls, 1), false).materialize().flatMap(n -> Tx.toTx(n, (Connection)connection.get(), db)).doOnNext(tx -> {
                if (tx.isComplete()) {
                    ((TxImpl)tx).connection().commit();
                }
            });
        });
    }

    public static final class TransactedSelectAutomappedBuilderValuesOnly<T> {
        private final TransactedSelectAutomappedBuilder<T> b;
        private final Database db;

        TransactedSelectAutomappedBuilderValuesOnly(TransactedSelectAutomappedBuilder<T> b, Database db) {
            this.b = b;
            this.db = db;
        }

        public Flowable<T> get() {
            return TransactedSelectAutomappedBuilder.createFlowable(((TransactedSelectAutomappedBuilder)this.b).selectBuilder, this.db).flatMap(Tx.flattenToValuesOnly());
        }
    }
}

