/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.sql.Connection;
import javax.annotation.Nonnull;
import org.davidmoten.rx.jdbc.Database;
import org.davidmoten.rx.jdbc.DependsOn;
import org.davidmoten.rx.jdbc.ParametersBuilder;
import org.davidmoten.rx.jdbc.ReturnGeneratedKeysBuilder;
import org.davidmoten.rx.jdbc.TransactedUpdateBuilder;
import org.davidmoten.rx.jdbc.Tx;
import org.davidmoten.rx.jdbc.Update;

public final class UpdateBuilder
extends ParametersBuilder<UpdateBuilder>
implements DependsOn<UpdateBuilder> {
    static final int DEFAULT_BATCH_SIZE = 1;
    final String sql;
    final Single<Connection> connections;
    private final Database db;
    Flowable<?> dependsOn;
    int batchSize = 1;

    UpdateBuilder(String sql, Single<Connection> connections, Database db) {
        super(sql);
        this.sql = sql;
        this.connections = connections;
        this.db = db;
    }

    @Override
    public UpdateBuilder dependsOn(Flowable<?> flowable) {
        Preconditions.checkArgument((this.dependsOn == null ? 1 : 0) != 0, (String)"dependsOn can only be set once");
        this.dependsOn = flowable;
        return this;
    }

    public UpdateBuilder batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public ReturnGeneratedKeysBuilder returnGeneratedKeys() {
        Preconditions.checkArgument((this.batchSize == 1 ? 1 : 0) != 0, (String)"Cannot return generated keys if batchSize > 1");
        return new ReturnGeneratedKeysBuilder(this);
    }

    public Flowable<Integer> counts() {
        return this.startWithDependency(Update.create(this.connections, super.parameterGroupsToFlowable(), this.sql, this.batchSize, true).dematerialize());
    }

    <T> Flowable<T> startWithDependency(@Nonnull Flowable<T> f) {
        if (this.dependsOn != null) {
            return this.dependsOn.ignoreElements().andThen(f);
        }
        return f;
    }

    public TransactedUpdateBuilder transacted() {
        return new TransactedUpdateBuilder(this, this.db);
    }

    public Single<Tx<?>> transaction() {
        return this.transacted().tx();
    }

    public Completable complete() {
        return this.counts().ignoreElements();
    }
}

