/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.jdbc.pool;

import com.github.davidmoten.guavamini.Preconditions;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.schedulers.ExecutorScheduler;
import io.reactivex.schedulers.Schedulers;
import java.sql.Connection;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.sql.DataSource;
import org.davidmoten.rx.jdbc.ConnectionProvider;
import org.davidmoten.rx.jdbc.Util;
import org.davidmoten.rx.jdbc.pool.DatabaseType;
import org.davidmoten.rx.jdbc.pool.internal.HealthCheckPredicate;
import org.davidmoten.rx.jdbc.pool.internal.PooledConnection;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.NonBlockingPool;
import org.davidmoten.rx.pool.Pool;

public final class NonBlockingConnectionPool
implements Pool<Connection> {
    private final AtomicReference<NonBlockingPool<Connection>> pool = new AtomicReference();

    NonBlockingConnectionPool(NonBlockingPool.Builder<Connection> builder) {
        this.pool.set(builder.build());
    }

    public static Builder<NonBlockingConnectionPool> builder() {
        return new Builder<NonBlockingConnectionPool>(x -> x);
    }

    @Override
    public Single<Member<Connection>> member() {
        return this.pool.get().member();
    }

    @Override
    public void close() {
        this.pool.get().close();
    }

    public static final class Builder<T> {
        private ConnectionProvider cp;
        private Predicate<? super Connection> healthCheck = c -> true;
        private int maxPoolSize = 5;
        private long idleTimeBeforeHealthCheckMs = 60000L;
        private long maxIdleTimeMs = 1800000L;
        private long createRetryIntervalMs = 30000L;
        private Consumer<? super Connection> disposer = Util::closeSilently;
        private Scheduler scheduler = null;
        private final Function<NonBlockingConnectionPool, T> transform;

        public Builder(Function<NonBlockingConnectionPool, T> transform) {
            this.transform = transform;
        }

        public Builder<T> connectionProvider(ConnectionProvider cp) {
            this.cp = cp;
            return this;
        }

        public Builder<T> connectionProvider(DataSource ds) {
            return this.connectionProvider(Util.connectionProvider(ds));
        }

        public Builder<T> url(String url) {
            return this.connectionProvider(Util.connectionProvider(url));
        }

        public Builder<T> maxIdleTime(long duration, TimeUnit unit) {
            this.maxIdleTimeMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> idleTimeBeforeHealthCheck(long duration, TimeUnit unit) {
            this.idleTimeBeforeHealthCheckMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> createRetryInterval(long duration, TimeUnit unit) {
            this.createRetryIntervalMs = unit.toMillis(duration);
            return this;
        }

        public Builder<T> healthCheck(Predicate<? super Connection> healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public Builder<T> healthCheck(DatabaseType databaseType) {
            return this.healthCheck(databaseType.healthCheck());
        }

        public Builder<T> healthCheck(String sql) {
            return this.healthCheck(new HealthCheckPredicate(sql));
        }

        public Builder<T> maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public Builder<T> scheduler(Scheduler scheduler) {
            Preconditions.checkArgument((scheduler != Schedulers.trampoline() ? 1 : 0) != 0, (String)"do not use trampoline scheduler because of risk of stack overflow");
            this.scheduler = scheduler;
            return this;
        }

        public T build() {
            if (this.scheduler == null) {
                ExecutorService executor = Executors.newFixedThreadPool(this.maxPoolSize);
                this.scheduler = new ExecutorScheduler((Executor)executor);
            }
            NonBlockingConnectionPool p = new NonBlockingConnectionPool(NonBlockingPool.factory(() -> this.cp.get()).checkinDecorator((con, checkin) -> new PooledConnection((Connection)con, (Checkin)checkin)).idleTimeBeforeHealthCheck(this.idleTimeBeforeHealthCheckMs, TimeUnit.MILLISECONDS).maxIdleTime(this.maxIdleTimeMs, TimeUnit.MILLISECONDS).createRetryInterval(this.createRetryIntervalMs, TimeUnit.MILLISECONDS).scheduler(this.scheduler).disposer(this.disposer).healthCheck(this.healthCheck).scheduler(this.scheduler).maxSize(this.maxPoolSize));
            return this.transform.apply(p);
        }
    }
}

