/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.rx.pool;

import io.reactivex.disposables.Disposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.davidmoten.rx.pool.Checkin;
import org.davidmoten.rx.pool.Member;
import org.davidmoten.rx.pool.MemberSingle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DecoratingMember<T>
implements Member<T> {
    private static final Logger log = LoggerFactory.getLogger(DecoratingMember.class);
    private volatile T value;
    private final MemberSingle<T> memberSingle;
    private final BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator;
    private Disposable scheduled;
    private boolean releasing;
    private boolean checking;
    private long lastCheckTime;

    DecoratingMember(T value, BiFunction<? super T, ? super Checkin, ? extends T> checkinDecorator, MemberSingle<T> memberSingle) {
        this.checkinDecorator = checkinDecorator;
        this.memberSingle = memberSingle;
        this.value = value;
    }

    @Override
    public T value() {
        return this.checkinDecorator.apply(this.value, this);
    }

    @Override
    public void checkin() {
        this.memberSingle.pool.checkin(this);
    }

    public void markAsReleasing() {
        this.releasing = true;
    }

    public boolean isReleasing() {
        return this.releasing;
    }

    public void markAsChecking() {
        this.checking = true;
    }

    public boolean isChecking() {
        return this.checking;
    }

    @Override
    public void disposeValue() {
        try {
            if (this.scheduled != null) {
                this.scheduled.dispose();
                this.scheduled = null;
            }
            log.debug("disposing value {}", this.value);
            this.memberSingle.pool.disposer.accept(this.value);
        }
        catch (Throwable e) {
            RxJavaPlugins.onError((Throwable)e);
        }
        finally {
            this.value = null;
            this.checking = false;
        }
    }

    public void setValueAndClearReleasingFlag(T value) {
        this.value = value;
        this.releasing = false;
        this.lastCheckTime = this.now();
    }

    void scheduleRelease() {
        long maxIdleTimeMs;
        if (this.scheduled != null) {
            this.scheduled.dispose();
            log.debug("cancelled scheduled release of {}", (Object)this);
        }
        if ((maxIdleTimeMs = this.memberSingle.pool.maxIdleTimeMs) > 0L) {
            this.scheduled = this.memberSingle.pool.scheduler.scheduleDirect(() -> this.memberSingle.addToBeReleased(this), maxIdleTimeMs, TimeUnit.MILLISECONDS);
            log.debug("scheduled release in {}ms of {}", (Object)maxIdleTimeMs, (Object)this);
        }
    }

    public String toString() {
        return "DecoratingMember [value=" + this.value + "]";
    }

    public void markAsChecked() {
        this.checking = false;
        this.lastCheckTime = this.now();
    }

    private long now() {
        return this.memberSingle.pool.scheduler.now(TimeUnit.MILLISECONDS);
    }

    public long lastCheckTime() {
        return this.lastCheckTime;
    }
}

