/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.fsm;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class Util {
    private Util() {
    }

    public static String lowerFirst(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public static String upperFirst(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String toClassSimpleName(String name) {
        return Util.upperFirst(Util.toJavaIdentifier(name));
    }

    public static String toJavaIdentifier(String name) {
        StringBuilder s = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i != 0 && !Character.isJavaIdentifierStart(ch) || !Character.isJavaIdentifierPart(ch)) {
                capitalize = true;
                continue;
            }
            if (capitalize) {
                s.append(Character.toUpperCase(ch));
                capitalize = false;
                continue;
            }
            s.append(ch);
        }
        return Util.lowerFirst(s.toString());
    }

    public static String toJavaConstantIdentifier(String name) {
        StringBuilder s = new StringBuilder();
        boolean funnyCharacter = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(ch) || i > 0 && !Character.isJavaIdentifierPart(ch)) {
                funnyCharacter = true;
                continue;
            }
            if (funnyCharacter) {
                s.append("_");
                s.append(Character.toUpperCase(ch));
                funnyCharacter = false;
                continue;
            }
            s.append(Character.toUpperCase(ch));
        }
        return s.toString();
    }

    @VisibleForTesting
    static boolean isLettersAndDigits(String s) {
        return Pattern.compile("[0-9a-zA-Z]*").matcher(s).matches();
    }

    public static String camelCaseToLowerUnderscore(String s) {
        if (s.toUpperCase().equals(s) && Util.isLettersAndDigits(s)) {
            return s.toLowerCase();
        }
        StringBuilder b = new StringBuilder();
        b.append(s.charAt(0));
        boolean underscoreAdded = false;
        boolean lastCharacterUppercase = false;
        for (int i = 1; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!Character.isLetterOrDigit(ch)) {
                if (!underscoreAdded) {
                    b.append('_');
                }
                underscoreAdded = true;
                lastCharacterUppercase = false;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                if (!underscoreAdded && !lastCharacterUppercase) {
                    b.append("_");
                }
                b.append(ch);
                underscoreAdded = false;
                lastCharacterUppercase = true;
                continue;
            }
            b.append(ch);
            underscoreAdded = false;
            lastCharacterUppercase = false;
        }
        return b.toString().toLowerCase();
    }

    public static String toTableName(String className) {
        return Util.camelCaseToLowerUnderscore(className);
    }

    public static String toTableIdName(String className) {
        return Util.toTableName(className) + "_id";
    }

    public static String toColumnName(String attributeName) {
        return Util.camelCaseToLowerUnderscore(attributeName);
    }

    public static String getPackage(String className) {
        if (!className.contains(".")) {
            return className;
        }
        return className.substring(0, className.lastIndexOf("."));
    }

    public static String getSimpleClassName(String className) {
        if (!className.contains(".")) {
            return className;
        }
        return className.substring(className.lastIndexOf(".") + 1, className.length());
    }

    public static String camelCaseToSpaced(String s) {
        return s.chars().mapToObj(ch -> {
            if (ch >= 65 && ch <= 90) {
                return " " + (char)ch;
            }
            return "" + (char)ch;
        }).collect(Collectors.joining(""));
    }
}

