/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.fsm.model;

import com.github.davidmoten.fsm.model.StateMachineDefinition;
import com.github.davidmoten.fsm.runtime.Event;
import java.io.File;
import java.util.Optional;

public final class State<T, R extends Event<? super T>> {
    private final String name;
    private final Class<R> eventClass;
    private final StateMachineDefinition<T> m;
    private boolean isCreationDestination;
    private Optional<String> documentation = Optional.empty();

    public State(StateMachineDefinition<T> m, String name, Class<R> eventClass) {
        this.m = m;
        this.name = name;
        this.eventClass = eventClass;
    }

    public Class<R> eventClass() {
        return this.eventClass;
    }

    public String name() {
        return this.name;
    }

    public Optional<String> documentation() {
        return this.documentation;
    }

    public StateMachineDefinition<?> stateMachine() {
        return this.m;
    }

    public <S extends Event<? super T>> State<T, S> to(State<T, S> other) {
        this.m.addTransition(this, other);
        return other;
    }

    public <S extends Event<? super T>> State<T, R> from(State<T, S> other) {
        this.m.addTransition(other, this);
        return this;
    }

    public State<T, R> initial() {
        this.isCreationDestination = true;
        this.m.addInitialTransition(this);
        return this;
    }

    public State<T, R> documentation(String html) {
        this.documentation = Optional.of(html);
        return this;
    }

    public boolean isCreationDestination() {
        return this.isCreationDestination;
    }

    public boolean isInitial() {
        return this.name().equals("Initial");
    }

    public void generateClasses(File directory, String pkg) {
        this.m.generateClasses(directory, pkg);
    }
}

