/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.SMTPException;
import org.subethamail.smtp.internal.Constants;
import org.subethamail.smtp.internal.io.DotTerminatedOutputStream;
import org.subethamail.smtp.internal.io.ExtraDotOutputStream;

public final class SMTPClient {
    private static final int CONNECT_TIMEOUT = 300000;
    private static final int REPLY_TIMEOUT = 600000;
    private static Logger log = LoggerFactory.getLogger(SMTPClient.class);
    private final Optional<SocketAddress> bindpoint;
    private volatile SocketAddress localSocketAddress;
    private boolean connected;
    private final Optional<String> hostPortName;
    Socket socket;
    BufferedReader reader;
    OutputStream rawOutput;
    DotTerminatedOutputStream dotTerminatedOutput;
    ExtraDotOutputStream dataOutput;
    PrintWriter writer;

    public SMTPClient() throws UnknownHostException, IOException {
        this(Optional.empty(), Optional.empty());
    }

    public SMTPClient(Optional<SocketAddress> bindpoint, Optional<String> hostPortName) throws UnknownHostException, IOException {
        Preconditions.checkNotNull(bindpoint, (String)"bindpoint cannot be null");
        this.bindpoint = bindpoint;
        this.hostPortName = hostPortName;
    }

    public static SMTPClient createAndConnect(String host, int port) throws UnknownHostException, IOException {
        return SMTPClient.createAndConnect(host, port, Optional.empty());
    }

    public static SMTPClient createAndConnect(String host, int port, Optional<String> hostPortName) throws UnknownHostException, IOException {
        SMTPClient client = new SMTPClient(Optional.empty(), Optional.of(hostPortName.orElse(host + ":" + port)));
        client.connect(host, port);
        return client;
    }

    public void connect(String host, int port) throws IOException {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        log.debug("Connecting to {}", this.hostPortName);
        this.socket = this.createSocket();
        this.socket.bind(this.bindpoint.orElse(null));
        this.socket.setSoTimeout(600000);
        this.socket.connect(new InetSocketAddress(host, port), 300000);
        try {
            this.localSocketAddress = this.socket.getLocalSocketAddress();
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), Constants.SMTP_CHARSET));
            this.rawOutput = this.socket.getOutputStream();
            this.dotTerminatedOutput = new DotTerminatedOutputStream(this.rawOutput);
            this.dataOutput = new ExtraDotOutputStream(this.dotTerminatedOutput);
            this.writer = new PrintWriter(this.rawOutput, true);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        this.connected = true;
    }

    protected Socket createSocket() {
        return new Socket();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void send(String msg) throws IOException {
        log.debug("Client: {}", (Object)msg);
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        this.writer.print(msg + "\r\n");
        this.writer.flush();
    }

    protected Response receive() throws IOException {
        int code;
        if (!this.connected) {
            throw new IllegalStateException("Not connected");
        }
        StringBuilder builder = new StringBuilder();
        String line = null;
        boolean done = false;
        do {
            if ((line = this.reader.readLine()) == null) {
                if (builder.length() == 0) {
                    throw new EOFException("Server disconnected unexpectedly, no reply received");
                }
                throw new IOException("Malformed SMTP reply: " + builder);
            }
            log.debug("Server: {}", (Object)line);
            if (line.length() < 4) {
                throw new IOException("Malformed SMTP reply: " + line);
            }
            builder.append(line.substring(4));
            if (line.charAt(3) == '-') {
                builder.append('\n');
                continue;
            }
            done = true;
        } while (!done);
        String codeString = line.substring(0, 3);
        try {
            code = Integer.parseInt(codeString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Malformed SMTP reply: " + line, e);
        }
        return new Response(code, builder.toString());
    }

    public Response sendReceive(String msg) throws IOException {
        this.send(msg);
        return this.receive();
    }

    public Response receiveAndCheck() throws IOException, SMTPException {
        Response resp = this.receive();
        if (!resp.isSuccess()) {
            throw new SMTPException(resp);
        }
        return resp;
    }

    public Response sendAndCheck(String msg) throws IOException, SMTPException {
        this.send(msg);
        return this.receiveAndCheck();
    }

    public void close() {
        this.connected = false;
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
                log.debug("Closed connection to {}", this.hostPortName);
            }
            catch (IOException ex) {
                log.error("Problem closing connection to " + this.hostPortName, (Throwable)ex);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { " + this.hostPortName + "}";
    }

    public SocketAddress getLocalSocketAddress() {
        return this.localSocketAddress;
    }

    public String getHostPort() {
        return this.hostPortName.orElse(null);
    }

    public static final class Response {
        int code;
        String message;

        public Response(int code, String text) {
            this.code = code;
            this.message = text;
        }

        public int getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isSuccess() {
            return this.code >= 100 && this.code < 400;
        }

        public String toString() {
            return this.code + " " + this.message;
        }
    }
}

