/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.client;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.client.AuthenticationNotSupportedException;
import org.subethamail.smtp.client.Authenticator;
import org.subethamail.smtp.client.SMTPClient;
import org.subethamail.smtp.client.SMTPException;

public class SmartClient {
    private static final Logger log = LoggerFactory.getLogger(SmartClient.class);
    private final String heloHost;
    private final Map<String, String> extensions = new HashMap<String, String>();
    private final Optional<Authenticator> authenticator;
    private final SMTPClient client;
    private int recipientCount;
    private boolean serverClosingTransmissionChannel = false;

    private SmartClient(String myHost) throws UnknownHostException, IOException, SMTPException {
        this(Optional.empty(), myHost, Optional.empty());
    }

    private SmartClient(Optional<SocketAddress> bindpoint, String clientHeloHost, Optional<Authenticator> authenticator) throws UnknownHostException, IOException, SMTPException {
        Preconditions.checkNotNull(bindpoint, (String)"bindpoint cannot be null");
        Preconditions.checkNotNull((Object)clientHeloHost, (String)"clientHeloHost cannot be null");
        Preconditions.checkNotNull(authenticator, (String)"authenticator cannot be null");
        this.client = new SMTPClient(bindpoint, Optional.empty());
        this.heloHost = clientHeloHost;
        this.authenticator = authenticator;
    }

    public static final SmartClient createAndConnect(String host, int port, String clientHeloHost) throws UnknownHostException, SMTPException, IOException {
        return SmartClient.createAndConnect(host, port, Optional.empty(), clientHeloHost, Optional.empty());
    }

    public static final SmartClient createAndConnect(String host, int port, Optional<SocketAddress> bindpoint, String clientHeloHost, Optional<Authenticator> authenticator) throws UnknownHostException, SMTPException, IOException {
        SmartClient client = new SmartClient(bindpoint, clientHeloHost, authenticator);
        client.connect(host, port);
        return client;
    }

    public void connect(String host, int port) throws SMTPException, AuthenticationNotSupportedException, IOException {
        this.client.connect(host, port);
        try {
            this.client.receiveAndCheck();
            this.sendHeloOrEhlo();
            if (this.authenticator.isPresent()) {
                this.authenticator.get().authenticate();
            }
        }
        catch (SMTPException e) {
            this.quit();
            throw e;
        }
        catch (AuthenticationNotSupportedException e) {
            this.quit();
            throw e;
        }
        catch (IOException e) {
            this.client.close();
            throw e;
        }
    }

    protected void sendHeloOrEhlo() throws IOException, SMTPException {
        this.extensions.clear();
        SMTPClient.Response resp = this.client.sendReceive("EHLO " + this.heloHost);
        if (resp.isSuccess()) {
            this.parseEhloResponse(resp);
        } else if (resp.getCode() == 500 || resp.getCode() == 502) {
            this.client.sendAndCheck("HELO " + this.heloHost);
        } else {
            throw new SMTPException(resp);
        }
    }

    private void parseEhloResponse(SMTPClient.Response resp) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(resp.getMessage()));
        reader.readLine();
        while (null != (line = reader.readLine())) {
            int iFirstSpace = line.indexOf(32);
            String keyword = iFirstSpace == -1 ? line : line.substring(0, iFirstSpace);
            String parameters = iFirstSpace == -1 ? "" : line.substring(iFirstSpace + 1);
            this.extensions.put(keyword.toUpperCase(Locale.ENGLISH), parameters);
        }
    }

    protected SMTPClient.Response receive() throws IOException {
        SMTPClient.Response response = this.client.receive();
        if (response.getCode() == 421) {
            this.serverClosingTransmissionChannel = true;
        }
        return response;
    }

    public void from(String from) throws IOException, SMTPException {
        this.client.sendAndCheck("MAIL FROM: <" + from + ">");
    }

    public void to(String to) throws IOException, SMTPException {
        this.client.sendAndCheck("RCPT TO: <" + to + ">");
        ++this.recipientCount;
    }

    public void dataStart() throws IOException, SMTPException {
        this.client.sendAndCheck("DATA");
    }

    public void bdat(String text, boolean isLast) throws IOException {
        this.client.send("BDAT " + text.length() + (isLast ? " LAST" : ""));
        this.dataWrite(text.getBytes(StandardCharsets.UTF_8));
        this.client.dataOutput.flush();
        this.client.receiveAndCheck();
    }

    public void bdat(String text) throws IOException {
        this.bdat(text, false);
    }

    public void bdatLast(String text) throws IOException {
        this.bdat(text, true);
    }

    public void dataWrite(byte[] data, int numBytes) throws IOException {
        this.client.dataOutput.write(data, 0, numBytes);
    }

    public void dataWrite(byte[] data) throws IOException {
        this.client.dataOutput.write(data, 0, data.length);
    }

    public void dataEnd() throws IOException, SMTPException {
        this.client.dataOutput.flush();
        this.client.dotTerminatedOutput.writeTerminatingSequence();
        this.client.dotTerminatedOutput.flush();
        this.client.receiveAndCheck();
    }

    public void quit() {
        try {
            if (this.client.isConnected() && !this.serverClosingTransmissionChannel) {
                this.client.sendAndCheck("QUIT");
            }
        }
        catch (IOException ex) {
            log.warn("Failed to issue QUIT to " + this.client.getHostPort());
        }
        this.client.close();
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public Map<String, String> getExtensions() {
        return this.extensions;
    }

    public String getHeloHost() {
        return this.heloHost;
    }

    public Optional<Authenticator> getAuthenticator() {
        return this.authenticator;
    }

    public void sendAndCheck(String msg) throws SMTPException, IOException {
        this.client.sendAndCheck(msg);
    }
}

