/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.command;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.internal.server.BaseCommand;
import org.subethamail.smtp.internal.util.TextUtils;
import org.subethamail.smtp.server.Session;

public final class EhloCommand
extends BaseCommand {
    public EhloCommand() {
        super("EHLO", "Introduce yourself.", "<hostname>");
    }

    @Override
    public void execute(String commandString, Session sess) throws IOException {
        List<String> supportedMechanisms;
        boolean displayAuth;
        String[] args = EhloCommand.getArgs(commandString);
        if (args.length < 2) {
            sess.sendResponse("501 Syntax: EHLO hostname");
            return;
        }
        sess.resetMailTransaction();
        sess.setHelo(args[1]);
        StringBuilder response = new StringBuilder();
        response.append("250-");
        response.append(sess.getServer().getHostName());
        response.append("\r\n250-8BITMIME");
        int maxSize = sess.getServer().getMaxMessageSize();
        if (maxSize > 0) {
            response.append("\r\n250-SIZE ");
            response.append(maxSize);
        }
        if (sess.getServer().getEnableTLS() && !sess.getServer().getHideTLS()) {
            response.append("\r\n250-STARTTLS");
        }
        response.append("\r\n250-CHUNKING");
        Optional<AuthenticationHandlerFactory> authFact = sess.getServer().getAuthenticationHandlerFactory();
        if (sess.isTLSStarted()) {
            displayAuth = authFact.isPresent();
        } else {
            boolean bl = displayAuth = authFact.isPresent() && !sess.getServer().getRequireTLS();
        }
        if (displayAuth && !(supportedMechanisms = authFact.get().getAuthenticationMechanisms()).isEmpty()) {
            response.append("\r\n250-AUTH ");
            response.append(TextUtils.joinTogether(supportedMechanisms, " "));
        }
        response.append("\r\n250 Ok");
        sess.sendResponse(response.toString());
    }
}

