/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.io;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import org.subethamail.smtp.internal.util.TextUtils;

public final class ReceivedHeaderStream
extends FilterInputStream {
    ByteArrayInputStream header;

    public ReceivedHeaderStream(InputStream in, Optional<String> heloHost, InetAddress host, String whoami, Optional<String> softwareName, String id, Optional<String> singleRecipient) {
        super(in);
        Preconditions.checkNotNull(heloHost);
        Preconditions.checkNotNull(softwareName);
        Preconditions.checkNotNull(singleRecipient);
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z (z)", Locale.US);
        String timestamp = fmt.format(new Date());
        StringBuilder header = new StringBuilder();
        header.append("Received: from " + (String)heloHost.orElse(null) + " (" + this.constructTcpInfo(host) + ")\r\n");
        header.append("        by " + whoami + "\r\n");
        header.append("        with SMTP");
        if (softwareName.isPresent()) {
            header.append(" (" + softwareName.get() + ")");
        }
        header.append(" id ").append(id);
        if (singleRecipient.isPresent()) {
            header.append("\r\n        for " + singleRecipient.get());
        }
        header.append(";\r\n");
        header.append("        " + timestamp + "\r\n");
        this.header = new ByteArrayInputStream(TextUtils.getAsciiBytes(header.toString()));
    }

    private String constructTcpInfo(InetAddress host) {
        String address;
        String domain = host.getCanonicalHostName();
        if (domain.equals(address = host.getHostAddress())) {
            return "[" + address + "]";
        }
        return domain + " [" + address + "]";
    }

    @Override
    public int available() throws IOException {
        return this.header.available() + super.available();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.header.available() > 0) {
            return this.header.read();
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.header.available() > 0) {
            int countRead = this.header.read(b, off, len);
            if (countRead < len) {
                int remainder = len - countRead;
                int additionalRead = super.read(b, off + countRead, remainder);
                return countRead + additionalRead;
            }
            return countRead;
        }
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

