/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.helper.BasicMessageHandlerFactory;
import org.subethamail.smtp.helper.BasicMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListenerAdapter;
import org.subethamail.smtp.internal.server.AcceptAllSessionHandler;
import org.subethamail.smtp.internal.server.CommandHandler;
import org.subethamail.smtp.internal.server.ServerThread;
import org.subethamail.smtp.server.SSLSocketCreator;
import org.subethamail.smtp.server.ServerSocketCreator;
import org.subethamail.smtp.server.SessionHandler;
import org.subethamail.smtp.server.SessionIdFactory;
import org.subethamail.smtp.server.TimeBasedSessionIdFactory;

public final class SMTPServer
implements SSLSocketCreator {
    private static final Logger log = LoggerFactory.getLogger(SMTPServer.class);
    private static final String UNKNOWN_HOSTNAME = "localhost";
    private static final int MAX_MESSAGE_SIZE_UNLIMITED = 0;
    private final Optional<InetAddress> bindAddress;
    private final int port;
    private final String hostName;
    private final int backlog;
    private final String softwareName;
    private final MessageHandlerFactory messageHandlerFactory;
    private final Optional<AuthenticationHandlerFactory> authenticationHandlerFactory;
    private final ExecutorService executorService;
    private final CommandHandler commandHandler;
    private final boolean enableTLS;
    private final boolean hideTLS;
    private final boolean requireTLS;
    private final boolean requireAuth;
    private final boolean disableReceivedHeaders;
    private final int maxConnections;
    private final int connectionTimeoutMs;
    private final int maxRecipients;
    private final int maxMessageSize;
    private final SessionIdFactory sessionIdFactory;
    private final SessionHandler sessionHandler;
    @GuardedBy(value="this")
    private ServerThread serverThread;
    private final Function<SMTPServer, String> serverThreadName;
    @GuardedBy(value="this")
    private boolean started = false;
    private volatile int allocatedPort;
    private final SSLSocketCreator startTlsSocketCreator;
    private final ServerSocketCreator serverSocketCreator;
    private static final SSLSocketCreator SSL_SOCKET_CREATOR_DEFAULT = new SSLSocketCreator(){

        @Override
        public SSLSocket createSSLSocket(Socket socket) throws IOException {
            SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
            InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
            SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
            s.setUseClientMode(false);
            s.setEnabledCipherSuites(s.getSupportedCipherSuites());
            return s;
        }
    };
    private static final ServerSocketCreator SERVER_SOCKET_CREATOR_DEFAULT = new ServerSocketCreator(){

        @Override
        public ServerSocket createServerSocket() throws IOException {
            return new ServerSocket();
        }
    };
    private static final MessageHandlerFactory MESSAGE_HANDLER_FACTORY_DEFAULT = new BasicMessageHandlerFactory((context, from, to, data) -> log.info("From: " + from + ", To: " + to + "\n" + new String(data, StandardCharsets.UTF_8) + "\n--------END OF MESSAGE ------------"), 0);

    private SMTPServer(Optional<String> hostName, Optional<InetAddress> bindAddress, int port, int backlog, String softwareName, MessageHandlerFactory messageHandlerFactory, Optional<AuthenticationHandlerFactory> authenticationHandlerFactory, Optional<ExecutorService> executorService, boolean enableTLS, boolean hideTLS, boolean requireTLS, boolean requireAuth, boolean disableReceivedHeaders, int maxConnections, int connectionTimeoutMs, int maxRecipients, int maxMessageSize, SessionIdFactory sessionIdFactory, SessionHandler sessionHandler, SSLSocketCreator startTlsSocketFactory, ServerSocketCreator serverSocketCreator, Function<SMTPServer, String> serverThreadNameProvider) {
        Preconditions.checkNotNull((Object)messageHandlerFactory);
        Preconditions.checkNotNull(bindAddress);
        Preconditions.checkNotNull(executorService);
        Preconditions.checkNotNull(authenticationHandlerFactory);
        Preconditions.checkNotNull((Object)sessionIdFactory);
        Preconditions.checkNotNull((Object)sessionHandler);
        Preconditions.checkNotNull(hostName);
        Preconditions.checkNotNull(serverThreadNameProvider);
        Preconditions.checkArgument((!requireAuth || authenticationHandlerFactory.isPresent() ? 1 : 0) != 0, (String)"if requireAuth is set to true then you must specify an authenticationHandlerFactory");
        Preconditions.checkNotNull((Object)startTlsSocketFactory, (String)"startTlsSocketFactory cannot be null");
        this.bindAddress = bindAddress;
        this.port = port;
        this.backlog = backlog;
        this.softwareName = softwareName;
        this.messageHandlerFactory = messageHandlerFactory;
        this.authenticationHandlerFactory = authenticationHandlerFactory;
        this.enableTLS = enableTLS;
        this.hideTLS = hideTLS;
        this.requireTLS = requireTLS;
        this.requireAuth = requireAuth;
        this.disableReceivedHeaders = disableReceivedHeaders;
        this.maxConnections = maxConnections;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.maxRecipients = maxRecipients;
        this.maxMessageSize = maxMessageSize;
        this.sessionIdFactory = sessionIdFactory;
        this.sessionHandler = sessionHandler;
        this.commandHandler = new CommandHandler();
        this.serverSocketCreator = serverSocketCreator;
        this.startTlsSocketCreator = startTlsSocketFactory;
        this.executorService = executorService.isPresent() ? executorService.get() : Executors.newCachedThreadPool();
        if (!hostName.isPresent()) {
            String s;
            try {
                s = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                s = UNKNOWN_HOSTNAME;
            }
            this.hostName = s;
        } else {
            this.hostName = hostName.get();
        }
        this.allocatedPort = port;
        this.serverThreadName = serverThreadNameProvider;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Optional<InetAddress> getBindAddress() {
        return this.bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public int getPortAllocated() {
        return this.allocatedPort;
    }

    public String getSoftwareName() {
        return this.softwareName;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public synchronized boolean isRunning() {
        return this.serverThread != null;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public synchronized void start() {
        ServerSocket serverSocket;
        log.info("SMTP server {} starting", (Object)this.getDisplayableLocalSocketAddress());
        if (this.started) {
            throw new IllegalStateException("SMTPServer can only be started once. Restarting is not allowed even after a proper shutdown.");
        }
        try {
            serverSocket = this.createServerSocket();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.serverThread = new ServerThread(this, serverSocket);
        this.serverThread.start();
        this.started = true;
    }

    public synchronized void stop() {
        log.info("SMTP server {} stopping...", (Object)this.getDisplayableLocalSocketAddress());
        if (this.serverThread == null) {
            return;
        }
        this.serverThread.shutdown();
        this.serverThread = null;
        log.info("SMTP server {} stopped", (Object)this.getDisplayableLocalSocketAddress());
    }

    private ServerSocket createServerSocket() throws IOException {
        InetSocketAddress isa = !this.bindAddress.isPresent() ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress.orElse(null), this.port);
        ServerSocket serverSocket = this.serverSocketCreator.createServerSocket();
        serverSocket.bind(isa, this.backlog);
        if (this.port == 0) {
            this.allocatedPort = serverSocket.getLocalPort();
        }
        return serverSocket;
    }

    @Override
    public final SSLSocket createSSLSocket(Socket socket) throws IOException {
        return this.startTlsSocketCreator.createSSLSocket(socket);
    }

    public String getDisplayableLocalSocketAddress() {
        return this.bindAddress.map(x -> x.toString()).orElse("*") + ":" + this.port;
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public Optional<AuthenticationHandlerFactory> getAuthenticationHandlerFactory() {
        return this.authenticationHandlerFactory;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeoutMs;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public boolean getEnableTLS() {
        return this.enableTLS;
    }

    public boolean getHideTLS() {
        return this.hideTLS;
    }

    public boolean getRequireTLS() {
        return this.requireTLS;
    }

    public boolean getRequireAuth() {
        return this.requireAuth;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public boolean getDisableReceivedHeaders() {
        return this.disableReceivedHeaders;
    }

    public SessionIdFactory getSessionIdFactory() {
        return this.sessionIdFactory;
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public static Builder port(int port) {
        return new Builder().port(port);
    }

    public String getServerThreadName() {
        return this.serverThreadName.apply(this);
    }

    static /* synthetic */ SSLSocketCreator access$100() {
        return SSL_SOCKET_CREATOR_DEFAULT;
    }

    static /* synthetic */ ServerSocketCreator access$200() {
        return SERVER_SOCKET_CREATOR_DEFAULT;
    }

    public static final class Builder {
        private Optional<String> hostName = Optional.empty();
        private Optional<InetAddress> bindAddress = Optional.empty();
        private int port = 25;
        private int backlog = 50;
        private String softwareName = "SubEthaSMTP " + Version.getSpecification();
        private Optional<BasicMessageListener> listener = Optional.empty();
        private MessageHandlerFactory messageHandlerFactory = SMTPServer.access$000();
        private Optional<AuthenticationHandlerFactory> authenticationHandlerFactory = Optional.empty();
        private Optional<ExecutorService> executorService = Optional.empty();
        private boolean enableTLS = false;
        private boolean hideTLS = false;
        private boolean requireTLS = false;
        private boolean requireAuth = false;
        private boolean disableReceivedHeaders = false;
        private int maxConnections = 1000;
        private int connectionTimeoutMs = 60000;
        private int maxRecipients = 1000;
        private int maxMessageSize = 0;
        private SessionIdFactory sessionIdFactory = new TimeBasedSessionIdFactory();
        private SessionHandler sessionHandler = AcceptAllSessionHandler.INSTANCE;
        private SSLSocketCreator startTlsSocketCreator = SMTPServer.access$100();
        private ServerSocketCreator serverSocketCreator = SMTPServer.access$200();
        private Function<SMTPServer, String> serverThreadNameProvider = server -> ServerThread.class.getName() + " " + server.getDisplayableLocalSocketAddress();

        public Builder bindAddress(InetAddress bindAddress) {
            Preconditions.checkNotNull((Object)bindAddress, (String)"bindAddress cannot be null");
            this.bindAddress = Optional.of(bindAddress);
            return this;
        }

        public Builder bindAddress(Optional<InetAddress> bindAddress) {
            Preconditions.checkNotNull(bindAddress, (String)"bindAddress cannot be null");
            this.bindAddress = bindAddress;
            return this;
        }

        public Builder hostName(String hostName) {
            Preconditions.checkNotNull((Object)hostName);
            this.hostName = Optional.of(hostName);
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder backlog(int backlogSize) {
            Preconditions.checkArgument((backlogSize >= 0 ? 1 : 0) != 0);
            this.backlog = backlogSize;
            return this;
        }

        public Builder softwareName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.softwareName = name;
            return this;
        }

        public Builder messageHandler(BasicMessageListener listener) {
            this.listener = Optional.of(listener);
            return this;
        }

        public Builder messageHandlerFactory(MessageHandlerFactory factory) {
            Preconditions.checkNotNull((Object)factory);
            Preconditions.checkArgument((this.messageHandlerFactory == MESSAGE_HANDLER_FACTORY_DEFAULT ? 1 : 0) != 0, (String)"can only set message handler factory once");
            this.messageHandlerFactory = factory;
            return this;
        }

        public Builder simpleMessageListener(SimpleMessageListener listener) {
            this.messageHandlerFactory = new SimpleMessageListenerAdapter(listener);
            return this;
        }

        public Builder authenticationHandlerFactory(AuthenticationHandlerFactory factory) {
            Preconditions.checkNotNull((Object)factory);
            this.authenticationHandlerFactory = Optional.of(factory);
            return this;
        }

        public Builder executorService(ExecutorService executor) {
            Preconditions.checkNotNull((Object)executor);
            this.executorService = Optional.of(executor);
            return this;
        }

        public Builder enableTLS(boolean value) {
            this.enableTLS = value;
            return this;
        }

        public Builder enableTLS() {
            return this.enableTLS(true);
        }

        public Builder hideTLS(boolean value) {
            this.hideTLS = value;
            return this;
        }

        public Builder hideTLS() {
            return this.hideTLS(true);
        }

        public Builder requireTLS(boolean value) {
            this.requireTLS = value;
            if (value) {
                this.enableTLS = true;
            }
            return this;
        }

        public Builder requireTLS() {
            return this.requireTLS(true);
        }

        public Builder requireAuth(boolean value) {
            this.requireAuth = value;
            return this;
        }

        public Builder requireAuth() {
            return this.requireAuth(true);
        }

        public Builder insertReceivedHeaders(boolean value) {
            this.disableReceivedHeaders = !value;
            return this;
        }

        public Builder insertReceivedHeaders() {
            this.disableReceivedHeaders = false;
            return this;
        }

        public Builder maxConnections(int maxConnections) {
            this.maxConnections = maxConnections;
            return this;
        }

        public Builder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout, TimeUnit unit) {
            return this.connectionTimeoutMs((int)unit.toMillis(connectionTimeout));
        }

        public Builder maxRecipients(int maxRecipients) {
            this.maxRecipients = maxRecipients;
            return this;
        }

        public Builder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public Builder sessionIdFactory(SessionIdFactory factory) {
            this.sessionIdFactory = factory;
            return this;
        }

        public Builder sessionHandler(SessionHandler sessionHandler) {
            this.sessionHandler = sessionHandler;
            return this;
        }

        public Builder serverSocketFactory(ServerSocketCreator serverSocketCreator) {
            this.serverSocketCreator = serverSocketCreator;
            return this;
        }

        public Builder serverSocketFactory(final SSLServerSocketFactory factory) {
            return this.serverSocketFactory(new ServerSocketCreator(){

                @Override
                public ServerSocket createServerSocket() throws IOException {
                    return factory.createServerSocket();
                }
            });
        }

        public Builder serverSocketFactory(SSLContext context) {
            return this.serverSocketFactory(context.getServerSocketFactory());
        }

        public Builder startTlsSocketFactory(SSLSocketCreator creator) {
            this.startTlsSocketCreator = creator;
            return this;
        }

        public Builder startTlsSocketFactory(SSLContext context) {
            return this.startTlsSocketFactory(context, false);
        }

        public Builder startTlsSocketFactory(final SSLContext context, final boolean requireClientCertificate) {
            return this.startTlsSocketFactory(new SSLSocketCreator(){

                @Override
                public SSLSocket createSSLSocket(Socket socket) throws IOException {
                    InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                    SSLSocketFactory sf = context.getSocketFactory();
                    SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
                    s.setUseClientMode(false);
                    s.setEnabledProtocols(s.getSupportedProtocols());
                    s.setEnabledCipherSuites(s.getSupportedCipherSuites());
                    if (requireClientCertificate) {
                        s.setNeedClientAuth(true);
                    }
                    return s;
                }
            });
        }

        public Builder serverThreadName(String name) {
            Preconditions.checkNotNull((Object)name);
            this.serverThreadNameProvider = server -> name;
            return this;
        }

        public Builder serverThreadNameProvider(Function<SMTPServer, String> provider) {
            this.serverThreadNameProvider = provider;
            return this;
        }

        public SMTPServer build() {
            if (this.listener.isPresent()) {
                this.messageHandlerFactory(new BasicMessageHandlerFactory(this.listener.get(), this.maxMessageSize));
            }
            return new SMTPServer(this.hostName, this.bindAddress, this.port, this.backlog, this.softwareName, this.messageHandlerFactory, this.authenticationHandlerFactory, this.executorService, this.enableTLS, this.hideTLS, this.requireTLS, this.requireAuth, this.disableReceivedHeaders, this.maxConnections, this.connectionTimeoutMs, this.maxRecipients, this.maxMessageSize, this.sessionIdFactory, this.sessionHandler, this.startTlsSocketCreator, this.serverSocketCreator, this.serverThreadNameProvider);
        }
    }
}

