/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.WiserMessage;

public final class Wiser
implements SimpleMessageListener {
    private static final Logger log = LoggerFactory.getLogger(Wiser.class);
    private final SMTPServer server;
    private final List<WiserMessage> messages = Collections.synchronizedList(new ArrayList());
    private final Accepter accepter;
    private static final Accepter ACCEPTER_DEFAULT = (from, recipient) -> {
        log.debug("Accepting mail from {} to {}", (Object)from, (Object)recipient);
        return true;
    };

    public static Wiser port(int port) {
        return Wiser.create(SMTPServer.port(port));
    }

    public static Wiser create(SMTPServer.Builder builder) {
        return new Wiser(builder, ACCEPTER_DEFAULT);
    }

    public static Wiser create() {
        return new Wiser(SMTPServer.port(25).build(), ACCEPTER_DEFAULT);
    }

    public static WiserBuilder accepter(Accepter accepter) {
        return new WiserBuilder().accepter(accepter);
    }

    private Wiser(SMTPServer server, Accepter accepter) {
        this.server = server;
        this.accepter = accepter;
    }

    private Wiser(SMTPServer.Builder builder, Accepter accepter) {
        SimpleMessageListener s = new SimpleMessageListener(){

            @Override
            public boolean accept(String from, String recipient) {
                return Wiser.this.accept(from, recipient);
            }

            @Override
            public void deliver(String from, String recipient, InputStream data) throws TooMuchDataException, IOException {
                Wiser.this.deliver(from, recipient, data);
            }
        };
        this.server = builder.simpleMessageListener(s).build();
        this.accepter = accepter;
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    @Override
    public boolean accept(String from, String recipient) {
        return this.accepter.accept(from, recipient);
    }

    @Override
    public void deliver(String from, String recipient, InputStream data) throws TooMuchDataException, IOException {
        int current;
        log.debug("Delivering mail from {} to {}", (Object)from, (Object)recipient);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        data = new BufferedInputStream(data);
        while ((current = data.read()) >= 0) {
            out.write(current);
        }
        byte[] bytes = out.toByteArray();
        log.debug("Creating message from data with {} bytes", (Object)bytes.length);
        Session session = Session.getDefaultInstance((Properties)new Properties());
        this.messages.add(new WiserMessage(session, from, recipient, bytes));
    }

    public List<WiserMessage> getMessages() {
        return this.messages;
    }

    public SMTPServer getServer() {
        return this.server;
    }

    public void dumpMessages(PrintStream out) throws MessagingException {
        out.println("----- Start printing messages -----");
        for (WiserMessage wmsg : this.getMessages()) {
            wmsg.dumpMessage(out);
        }
        out.println("----- End printing messages -----");
    }

    public static void main(String[] args) throws Exception {
        Wiser wiser = Wiser.create();
        wiser.start();
    }

    static /* synthetic */ Accepter access$100() {
        return ACCEPTER_DEFAULT;
    }

    public static interface Accepter {
        public boolean accept(String var1, String var2);
    }

    public static final class WiserBuilder {
        private Accepter accepter = Wiser.access$100();
        private SMTPServer.Builder server;

        private WiserBuilder() {
        }

        public WiserBuilder accepter(Accepter accepter) {
            this.accepter = accepter;
            return this;
        }

        public Wiser server(SMTPServer.Builder server) {
            this.server = server;
            return new Wiser(server, this.accepter);
        }

        public Wiser port(int port) {
            this.server = SMTPServer.port(port);
            return new Wiser(this.server, this.accepter);
        }
    }
}

