/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.subethamail.smtp.internal.io.BetterByteArrayOutputStream;
import org.subethamail.smtp.internal.io.ThresholdingOutputStream;

public final class DeferredFileOutputStream
extends ThresholdingOutputStream {
    static final int INITIAL_BUF_SIZE = 8192;
    public static final String TMPFILE_PREFIX = "subetha";
    public static final String TMPFILE_SUFFIX = ".msg";
    File outFile;
    FileOutputStream outFileStream;
    boolean closed;
    boolean thresholdReached = false;

    public DeferredFileOutputStream(int transitionSize) {
        super(new BetterByteArrayOutputStream(8192), transitionSize);
    }

    @Override
    protected void thresholdReached(int current, int predicted) throws IOException {
        this.outFile = Files.createTempFile(TMPFILE_PREFIX, TMPFILE_SUFFIX, new FileAttribute[0]).toFile();
        this.outFileStream = new FileOutputStream(this.outFile);
        ((ByteArrayOutputStream)this.output).writeTo(this.outFileStream);
        this.output = new BufferedOutputStream(this.outFileStream);
    }

    public InputStream getInputStream() throws IOException {
        if (this.output instanceof BetterByteArrayOutputStream) {
            return ((BetterByteArrayOutputStream)this.output).getInputStream();
        }
        if (!this.closed) {
            this.output.flush();
            this.output.close();
            this.closed = true;
        }
        return new BufferedInputStream(new FileInputStream(this.outFile));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.output.flush();
            this.output.close();
            this.closed = true;
        }
        if (this.outFile != null) {
            this.outFile.delete();
        }
    }
}

