/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.internal.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public final class Utf8InputStreamReader
extends Reader {
    private final InputStream in;
    private final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    private final ByteBuffer bb = ByteBuffer.allocate(4);
    private int leftOver = -1;

    public Utf8InputStreamReader(InputStream in) {
        this.in = in;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int a = this.read();
            if (a == -1) {
                if (i == off) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)a;
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        CharBuffer r;
        if (this.leftOver != -1) {
            int v = this.leftOver;
            this.leftOver = -1;
            return v;
        }
        int b = this.in.read();
        if (b == -1) {
            return b;
        }
        int numBytes = Utf8InputStreamReader.numBytes(b);
        if (numBytes == 1) {
            return b;
        }
        this.bb.clear();
        this.bb.put((byte)b);
        for (int i = 0; i < numBytes - 1; ++i) {
            byte a = (byte)this.in.read();
            if (a == -1) {
                throw new EOFException();
            }
            if (!Utf8InputStreamReader.isContinuation(a)) {
                throw new InvalidUTF8EncodingException("wrong continuation bits, bytes after first in a UTF-8 character must start with bits 10");
            }
            this.bb.put(a);
        }
        this.bb.flip();
        try {
            r = this.decoder.decode(this.bb);
        }
        catch (CharacterCodingException e) {
            throw new InvalidUTF8EncodingException(e);
        }
        char v = r.get();
        if (r.limit() > 1) {
            this.leftOver = r.get();
        }
        return v;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private static boolean isContinuation(int a) {
        if (!Utf8InputStreamReader.bit(a, 1)) {
            return false;
        }
        return !Utf8InputStreamReader.bit(a, 2);
    }

    static int numBytes(int a) throws InvalidUTF8EncodingException {
        if (!Utf8InputStreamReader.bit(a, 1)) {
            return 1;
        }
        if (!Utf8InputStreamReader.bit(a, 2)) {
            throw new InvalidUTF8EncodingException("leading bits 10 illegal for first byte of UTF-8 character");
        }
        if (!Utf8InputStreamReader.bit(a, 3)) {
            return 2;
        }
        if (!Utf8InputStreamReader.bit(a, 4)) {
            return 3;
        }
        if (!Utf8InputStreamReader.bit(a, 5)) {
            return 4;
        }
        throw new InvalidUTF8EncodingException("leading bits 11111 illegal for first byte of UTF-8 character");
    }

    private static boolean bit(int a, int index) {
        return (a >> 8 - index & 1) == 1;
    }

    public static final class InvalidUTF8EncodingException
    extends IOException {
        public InvalidUTF8EncodingException(String message) {
            super(message);
        }

        public InvalidUTF8EncodingException(IOException cause) {
            super(cause);
        }
    }
}

