/*
 * Decompiled with CFR 0.152.
 */
package forklift;

import forklift.connectors.ConnectorException;
import forklift.connectors.ForkliftConnectorI;
import forklift.consumer.ConsumerDeploymentEvents;
import forklift.deployment.DeploymentWatch;
import forklift.exception.StartupException;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Forklift {
    private static Logger log = LoggerFactory.getLogger((String)"ForkLift");
    private ForkliftConnectorI connector;
    private AtomicBoolean running = new AtomicBoolean(false);

    public Forklift() {
        log.debug("Creating ForkLift");
    }

    public synchronized void start(ForkliftConnectorI connector) throws StartupException {
        this.connector = connector;
        try {
            this.connector.start();
        }
        catch (ConnectorException e) {
            throw new StartupException(e.getMessage());
        }
        this.running.set(true);
        log.debug("Init complete!");
    }

    public void shutdown() {
        if (!this.running.getAndSet(false)) {
            return;
        }
        try {
            this.connector.stop();
        }
        catch (ConnectorException e) {
            e.printStackTrace();
        }
    }

    public ForkliftConnectorI getConnector() {
        return this.connector;
    }

    public void setConnector(ForkliftConnectorI connector) {
        this.connector = connector;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public static void main(String[] args) throws StartupException {
        Forklift forklift = new Forklift();
        DeploymentWatch deployWatch = new DeploymentWatch(new File("/tmp"), new ConsumerDeploymentEvents(forklift));
        if (!forklift.isRunning()) {
            throw new RuntimeException("Unable to start Forklift.");
        }
    }
}

