/*
 * Decompiled with CFR 0.152.
 */
package forklift.consumer;

import forklift.decorators.BeanResolver;
import forklift.decorators.OnDeploy;
import forklift.decorators.OnUndeploy;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerService {
    private static final Logger log = LoggerFactory.getLogger(ConsumerService.class);
    private Class<?> clazz;
    private Object instance;
    private List<Method> beanResolvers = new ArrayList<Method>();
    private List<Method> onDeploy = new ArrayList<Method>();
    private List<Method> onUndeploy = new ArrayList<Method>();

    public ConsumerService(Class<?> clazz) {
        this.clazz = clazz;
        try {
            this.instance = clazz.newInstance();
            for (Method m : clazz.getDeclaredMethods()) {
                if (m.isAnnotationPresent(BeanResolver.class)) {
                    this.beanResolvers.add(m);
                    continue;
                }
                if (m.isAnnotationPresent(OnDeploy.class)) {
                    this.onDeploy.add(m);
                    continue;
                }
                if (!m.isAnnotationPresent(OnUndeploy.class)) continue;
                this.onUndeploy.add(m);
            }
        }
        catch (Exception e) {
            log.error("Unable to init consumer service", (Throwable)e);
        }
    }

    public Object resolve(Class c, String name) throws Exception {
        for (Method m : this.beanResolvers) {
            Object o = m.invoke(this.instance, c, name);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public void onDeploy() throws Exception {
        for (Method m : this.onDeploy) {
            m.invoke(this.instance, new Object[0]);
        }
    }

    public void onUndeploy() throws Exception {
        for (Method m : this.onUndeploy) {
            m.invoke(this.instance, new Object[0]);
        }
    }
}

